/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Assembler;
import edsim51sh.AssemblyAndHexFileFilter;
import edsim51sh.AssemblyCodeBox;
import edsim51sh.AssemblyFileFilter;
import edsim51sh.BugFrame;
import edsim51sh.ClipboardManager;
import edsim51sh.CodeNotSaved;
import edsim51sh.Cpu;
import edsim51sh.FileHandler;
import edsim51sh.HexFileFilter;
import edsim51sh.InfoButton;
import edsim51sh.Memory;
import edsim51sh.Sizes;
import edsim51sh.TargetBoard;
import edsim51sh.Text;
import edsim51sh.UnlockedAssemblyCodeFrame;
import edsim51sh.UpdateFreqPanel;
import edsim51sh.exceptions.Edsim51Exception;
import edsim51sh.gui.MemoryWindow;
import edsim51sh.instructions.ExecutedInstructionInfo;
import edsim51sh.instructions.Instruction;
import edsim51sh.ports.Port;
import edsim51sh.ports.PortPinDescriptions;
import edsim51sh.ports.PortPinsDescFrame;
import edsim51sh.settings.Settings;
import edsim51sh.settings.SettingsReaderWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class MainPanel
extends JPanel {
    String version;
    String diVersion = "EdSim51DI - Version 2.1.29";
    private String shVersion = "EdSim51SH - Version 1.2.24";
    Cpu cpu;
    Instruction[] instructions = null;
    boolean codeSaved = true;
    AssemblyFileFilter aff = new AssemblyFileFilter();
    HexFileFilter hff = new HexFileFilter();
    AssemblyAndHexFileFilter ahff = new AssemblyAndHexFileFilter();
    UnlockedAssemblyCodeFrame unlockedAssemblyCodeFrame;
    Settings settings;
    JFrame externalFrame;
    SettingsReaderWriter srw;
    private InfoButton bitFieldInfoButton;
    private boolean isDI;
    private boolean showMovxWarning = true;
    private UpdateFreqPanel updateFreqPanel;
    private JPanel messageUnlockZoomPanel = new JPanel();
    private JPanel unlockZoomPanel = new JPanel();
    private JButton unlockButton = new JButton();
    private JButton zoomButton = new JButton();
    private Sizes sizes = new Sizes();
    private BugFrame bugFrame = null;
    private ClipboardManager clipboard;
    private boolean fieldsEnabled = true;
    private String preAssembledCode;
    private Vector breakpoints = null;
    private Assembler assembler;
    private Thread thread;
    private JButton removeAllBreakpointsButton = new JButton();
    private JButton[] controlButtons;
    private AssemblyCodeBox assemblyCodeBox = new AssemblyCodeBox(this);
    private JTextField[] bitFields;
    private JTextField[] eightBitFields;
    private JLabel[] labels;
    private PortPinDescriptions ppDesc = null;
    private JPanel targetBoardPanel = new JPanel();
    private JScrollPane targetBoardScrollPane = new JScrollPane();
    private JLabel noTargetBoardLabel = new JLabel("No Target Board Connected");
    private JTextField sysClockField = new JTextField();
    private PortPinsDescFrame port0Frame = null;
    private PortPinsDescFrame port1Frame = null;
    private PortPinsDescFrame port2Frame = null;
    private PortPinsDescFrame port3Frame = null;
    private JButton port0DescZoomButton = new JButton("+");
    private JButton port1DescZoomButton = new JButton("+");
    private JButton port2DescZoomButton = new JButton("+");
    private JButton port3DescZoomButton = new JButton("+");
    private JButton newFile;
    private MemoryWindow memoryWindow;
    private Vector alwaysOnTopFrames = new Vector();
    private Vector alwaysOnTopCheckBoxes = new Vector();
    private TargetBoard targetBoard = null;
    private JLabel R0;
    private JLabel R1;
    private JLabel R2;
    private JLabel R3;
    private JLabel R4;
    private JLabel R5;
    private JLabel R6;
    private JLabel R7;
    private JTextField acc;
    private JLabel accLabel;
    private JLabel addLabel;
    private JLabel addrLabel;
    private JPanel assembly;
    private JScrollPane assemblyCodeBoxPanel;
    private JTextField b;
    private JLabel bLabel;
    private JTextField bit0;
    private JTextField bit1;
    private JTextField bit2;
    private JTextField bit3;
    private JTextField bit4;
    private JTextField bit5;
    private JTextField bit6;
    private JTextField bit7;
    private JTextField bitfieldByteAddress;
    private JPanel bitfieldPanel;
    private JPanel controlPanel;
    private JLabel copyright;
    private JLabel dataLabel;
    private JTextField dph;
    private JLabel dphLabel;
    private JTextField dpl;
    private JLabel dplLabel;
    private JButton fileOpen;
    private JButton fileSave;
    private JTextField ie;
    private JLabel ieLabel;
    private JTextField ip;
    private JLabel ipLabel;
    private JLabel latchLabel;
    private JScrollPane messageBoxPanel;
    public JTextField messageBox;
    private JPanel microcontroller;
    private JLabel microcontrollerLabel;
    private JTextField pc;
    private JLabel pcLabel;
    private JTextField pcon;
    private JLabel pconLabel;
    private JLabel pinsLabel;
    private JTextField port0;
    private JLabel port0Label;
    private JPanel port0Panel;
    private JTextField port0pins;
    private JTextField port1;
    private JLabel port1Label;
    private JPanel port1Panel;
    private JTextField port1pins;
    private JTextField port2;
    private JLabel port2Label;
    private JPanel port2Panel;
    private JTextField port2pins;
    private JTextField port3;
    private JLabel port3Label;
    private JPanel port3Panel;
    private JTextField port3pins;
    private JPanel portPinConnectionsPanel;
    private JTextField psw;
    private JLabel pswLabel;
    private JButton copy;
    private JButton paste;
    private Quit quit;
    private JTextField memoryWindowAddressField;
    private JTextField memoryWindowByteField;
    private JTextField register0;
    private JTextField register1;
    private JTextField register2;
    private JTextField register3;
    private JTextField register4;
    private JTextField register5;
    private JTextField register6;
    private JTextField register7;
    private JButton reset;
    private JButton run;
    private JTextField rxd;
    private JLabel rxdLabel;
    private JTextField sbuf;
    private JLabel sbufLabel;
    private JTextField sbufReadOnly;
    private JLabel sbufRonlyLabel;
    private JLabel sbufWonlyLabel;
    private JTextField scon;
    private JLabel sconLabel;
    private JTextField sp;
    private JLabel spLabel;
    private JButton step;
    private JTextField tcon;
    private JLabel tconLabel;
    private JTextField th0;
    private JLabel th0label;
    private JTextField th1;
    private JLabel th1label;
    private JTextField tl0;
    private JLabel tl0label;
    private JTextField tl1;
    private JLabel tl1label;
    private JTextField tmod;
    private JLabel tmodLabel;
    private JTextField txd;
    private JLabel txdLabel;
    private JLabel sysClockLabel;
    private JButton memoryTypeButton;

    MainPanel(JFrame externalFrame, String targetBoardTitle, boolean isDI) {
        this.isDI = isDI;
        if (isDI) {
            this.version = this.diVersion;
            targetBoardTitle = "";
        } else {
            this.version = this.shVersion;
        }
        this.externalFrame = externalFrame;
        this.srw = new SettingsReaderWriter(this, targetBoardTitle);
        this.settings = this.srw.readSettings();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String connectTargetBoard(TargetBoard targetBoard) {
        if (targetBoard == null) {
            this.connectBlankTargetBoard(false);
            return null;
        }
        this.targetBoard = targetBoard;
        String g = "[JPanel gui is null]";
        String t = "[String title is null or empty]";
        String v = "[String version is null or empty]";
        String p = "[PortPinDescriptions portPinDescriptions is null]";
        String status = null;
        JPanel gui = targetBoard.getGui();
        String title = targetBoard.getTitle();
        String version = targetBoard.getVersion();
        this.ppDesc = targetBoard.getPortPinDescriptions();
        if (gui == null) {
            status = g;
        }
        if (title == null || title.equals("")) {
            status = status + t;
        }
        if (version == null || version.equals("")) {
            status = status + v;
        }
        if (this.ppDesc == null) {
            status = status + p;
        }
        if (status == null) {
            this.cpu.memory.setTargetBoard(targetBoard);
            targetBoard.setCpu(this.cpu);
            targetBoard.setMainPanel(this);
            targetBoard.setTargetBoardGraphicsSize(this.settings.isSmall());
            this.addPortPinDesc();
            this.targetBoardScrollPane.setViewportView(gui);
            this.version = this.version + " & " + title + " " + version;
            status = "[Target Board Connected Succesfully]";
        } else {
            this.connectBlankTargetBoard(true);
        }
        return status;
    }

    private void newFileMouseClicked(MouseEvent evt) {
        this.revokeAlwaysOnTop();
        this.resetMouseClicked();
        if (!this.isCodeSaved()) {
            CodeNotSaved cns = new CodeNotSaved(this, "Existing source code not saved.\nSave file before creating a new one?", false);
            int response = cns.showConfirmDialog();
            if (response == 2) {
                return;
            }
            if (this.unlockedAssemblyCodeFrame != null) {
                this.unlockedAssemblyCodeFrame.refocus();
            }
        }
        this.assemblyCodeBox.setText("");
        this.messageBox.setText("");
        this.externalFrame.setTitle(this.version);
    }

    private void connectBlankTargetBoard(boolean failedAttempt) {
        this.addPortPinDesc();
        if (failedAttempt) {
            this.noTargetBoardLabel.setText("Target Board Connection Failed");
        }
        this.targetBoardScrollPane.setViewportView(this.noTargetBoardLabel);
    }

    public void addAlwaysOnTopFrame(JFrame frame) {
        this.alwaysOnTopFrames.addElement(frame);
    }

    public void addAlwaysOnTopCheckBox(JCheckBox box) {
        this.alwaysOnTopCheckBoxes.addElement(box);
    }

    public void init() {
        this.cpu = new Cpu();
        this.updateFreqPanel = new UpdateFreqPanel(this);
        this.assembler = null;
        this.initComponents();
        this.bitFields = new JTextField[10];
        this.bitFields[0] = this.bit0;
        this.bitFields[1] = this.bit1;
        this.bitFields[2] = this.bit2;
        this.bitFields[3] = this.bit3;
        this.bitFields[4] = this.bit4;
        this.bitFields[5] = this.bit5;
        this.bitFields[6] = this.bit6;
        this.bitFields[7] = this.bit7;
        this.bitFields[8] = this.txd;
        this.bitFields[9] = this.rxd;
        this.eightBitFields = new JTextField[36];
        this.eightBitFields[0] = this.b;
        this.eightBitFields[1] = this.acc;
        this.eightBitFields[2] = this.psw;
        this.eightBitFields[3] = this.ip;
        this.eightBitFields[4] = this.ie;
        this.eightBitFields[5] = this.pcon;
        this.eightBitFields[6] = this.dph;
        this.eightBitFields[7] = this.dpl;
        this.eightBitFields[8] = this.sp;
        this.eightBitFields[9] = this.register7;
        this.eightBitFields[10] = this.register6;
        this.eightBitFields[11] = this.register5;
        this.eightBitFields[12] = this.register4;
        this.eightBitFields[13] = this.register3;
        this.eightBitFields[14] = this.register2;
        this.eightBitFields[15] = this.register1;
        this.eightBitFields[16] = this.register0;
        this.eightBitFields[17] = this.tl0;
        this.eightBitFields[18] = this.th0;
        this.eightBitFields[19] = this.tl1;
        this.eightBitFields[20] = this.th1;
        this.eightBitFields[21] = this.tmod;
        this.eightBitFields[22] = this.tcon;
        this.eightBitFields[23] = this.sbuf;
        this.eightBitFields[24] = this.sbufReadOnly;
        this.eightBitFields[25] = this.scon;
        this.eightBitFields[26] = this.port0;
        this.eightBitFields[27] = this.port1;
        this.eightBitFields[28] = this.port2;
        this.eightBitFields[29] = this.port3;
        this.eightBitFields[30] = this.port0pins;
        this.eightBitFields[31] = this.port1pins;
        this.eightBitFields[32] = this.port2pins;
        this.eightBitFields[33] = this.port3pins;
        this.eightBitFields[34] = this.bitfieldByteAddress;
        this.eightBitFields[35] = this.memoryWindowByteField;
        this.labels = new JLabel[39];
        this.labels[0] = this.bLabel;
        this.labels[1] = this.accLabel;
        this.labels[2] = this.pswLabel;
        this.labels[3] = this.ipLabel;
        this.labels[4] = this.ieLabel;
        this.labels[5] = this.pconLabel;
        this.labels[6] = this.dphLabel;
        this.labels[7] = this.dplLabel;
        this.labels[8] = this.spLabel;
        this.labels[9] = this.R7;
        this.labels[10] = this.R6;
        this.labels[11] = this.R5;
        this.labels[12] = this.R4;
        this.labels[13] = this.R3;
        this.labels[14] = this.R2;
        this.labels[15] = this.R1;
        this.labels[16] = this.R0;
        this.labels[17] = this.tl0label;
        this.labels[18] = this.th0label;
        this.labels[19] = this.tl1label;
        this.labels[20] = this.th1label;
        this.labels[21] = this.tmodLabel;
        this.labels[22] = this.tconLabel;
        this.labels[23] = this.sbufLabel;
        this.labels[24] = this.sbufRonlyLabel;
        this.labels[25] = this.sbufWonlyLabel;
        this.labels[26] = this.sconLabel;
        this.labels[27] = this.rxdLabel;
        this.labels[28] = this.txdLabel;
        this.labels[29] = this.port0Label;
        this.labels[30] = this.port1Label;
        this.labels[31] = this.port2Label;
        this.labels[32] = this.port3Label;
        this.labels[33] = this.pinsLabel;
        this.labels[34] = this.latchLabel;
        this.labels[35] = this.pcLabel;
        this.labels[36] = this.addrLabel;
        this.labels[37] = this.addLabel;
        this.labels[38] = this.dataLabel;
        this.removeAllBreakpointsButton.setEnabled(false);
        FocusManager focusManager = FocusManager.getCurrentManager();
        focusManager.clearGlobalFocusOwner();
        this.updateMemoryWindow();
        this.fileOpen.addActionListener(new FileAction(this));
        this.fileSave.addActionListener(new FileAction(this));
        this.clipboard = new ClipboardManager();
        this.setRegistersToolTipText();
        this.controlButtons = new JButton[8];
        this.controlButtons[0] = this.reset;
        this.controlButtons[1] = this.step;
        this.controlButtons[2] = this.run;
        this.controlButtons[3] = this.newFile;
        this.controlButtons[4] = this.fileOpen;
        this.controlButtons[5] = this.fileSave;
        this.controlButtons[6] = this.copy;
        this.controlButtons[7] = this.paste;
        this.sysClockField.setText(String.valueOf(this.settings.getSystemFreq()));
        this.cpu.setMachineCycleLength(12.0 / this.settings.getSystemFreq());
    }

    private void addPortPinDesc() {
        int i;
        if (this.ppDesc == null) {
            this.ppDesc = new PortPinDescriptions();
        }
        this.ppDesc.setSize(this.settings.isSmall());
        GridBagConstraints gbc = new GridBagConstraints();
        int x = 0;
        int y = 0;
        for (i = 7; i >= 0; --i) {
            gbc.gridx = x++;
            gbc.gridy = y++;
            this.port0Panel.add((Component)this.ppDesc.getPinLabel(0, i), gbc);
            gbc.gridx = x++;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.port0Panel.add((Component)this.ppDesc.getField(0, i), gbc);
            gbc.gridx = x;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.port0Panel.add((Component)this.ppDesc.getDescriptionLabel(0, i), gbc);
            x = 0;
        }
        for (i = 15; i >= 8; --i) {
            gbc.gridx = x++;
            gbc.gridy = y++;
            this.port1Panel.add((Component)this.ppDesc.getPinLabel(0, i), gbc);
            gbc.gridx = x++;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.port1Panel.add((Component)this.ppDesc.getField(0, i), gbc);
            gbc.gridx = x;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.port1Panel.add((Component)this.ppDesc.getDescriptionLabel(0, i), gbc);
            x = 0;
        }
        for (i = 23; i >= 16; --i) {
            gbc.gridx = x++;
            gbc.gridy = y++;
            this.port2Panel.add((Component)this.ppDesc.getPinLabel(0, i), gbc);
            gbc.gridx = x++;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.port2Panel.add((Component)this.ppDesc.getField(0, i), gbc);
            gbc.gridx = x;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.port2Panel.add((Component)this.ppDesc.getDescriptionLabel(0, i), gbc);
            x = 0;
        }
        for (i = 31; i >= 24; --i) {
            gbc.gridx = x++;
            gbc.gridy = y++;
            this.port3Panel.add((Component)this.ppDesc.getPinLabel(0, i), gbc);
            gbc.gridx = x++;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.port3Panel.add((Component)this.ppDesc.getField(0, i), gbc);
            gbc.gridx = x;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.port3Panel.add((Component)this.ppDesc.getDescriptionLabel(0, i), gbc);
            x = 0;
        }
    }

    void setAssemblyCodeBoxFocus() {
        this.assemblyCodeBox.requestFocusInWindow();
    }

    boolean isCodeSaved() {
        return this.codeSaved || this.assemblyCodeBox.getText().equals("");
    }

    String getCode() {
        return this.assemblyCodeBox.getText();
    }

    void setMessageBox(String text) {
        this.messageBox.setText(text);
    }

    void zoomIn() {
        TargetBoard board;
        int i;
        this.bitFieldInfoButton.setSize(false);
        this.sysClockField.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setFont(this.sizes.fontLarge);
        this.microcontroller.setMaximumSize(this.sizes.microLarge);
        this.microcontroller.setMinimumSize(this.sizes.microLarge);
        this.microcontroller.setPreferredSize(this.sizes.microLarge);
        this.microcontrollerLabel.setFont(this.sizes.microLabelLarge);
        this.sysClockLabel.setFont(this.sizes.fontBoldLarge);
        this.copyright.setFont(this.sizes.copyrightFontLarge);
        for (i = 0; i < this.bitFields.length; ++i) {
            this.bitFields[i].setMaximumSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setMinimumSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setPreferredSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setFont(this.sizes.fontLarge);
        }
        for (i = 0; i < this.eightBitFields.length; ++i) {
            this.eightBitFields[i].setMaximumSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setMinimumSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setPreferredSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setFont(this.sizes.fontLarge);
        }
        for (i = 0; i < this.labels.length; ++i) {
            this.labels[i].setFont(this.sizes.fontBoldLarge);
        }
        this.pc.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setFont(this.sizes.fontLarge);
        this.memoryWindow.makeSmall(false);
        this.memoryWindowAddressField.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setFont(this.sizes.fontLarge);
        this.memoryTypeButton.setMaximumSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setMinimumSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setPreferredSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setFont(this.sizes.fontBoldLarge);
        this.removeAllBreakpointsButton.setMaximumSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setMinimumSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setPreferredSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setFont(this.sizes.fontBoldLarge);
        this.updateFreqPanel.setLabelFont(this.sizes.fontBoldLarge);
        this.updateFreqPanel.setMenuFont(this.sizes.comboBoxFontLarge);
        this.updateFreqPanel.setUpdateFreqComboBoxSize(this.sizes.updateFreqComboBoxLarge);
        this.assembly.setMaximumSize(this.sizes.assemblyLarge);
        this.assembly.setMinimumSize(this.sizes.assemblyLarge);
        this.assembly.setPreferredSize(this.sizes.assemblyLarge);
        this.assemblyCodeBoxPanel.setMaximumSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBoxPanel.setMinimumSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBoxPanel.setPreferredSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBox.setFontSize(false);
        this.messageBoxPanel.setMaximumSize(this.sizes.messageBoxPanelLarge);
        this.messageBoxPanel.setMinimumSize(this.sizes.messageBoxPanelLarge);
        this.messageBoxPanel.setPreferredSize(this.sizes.messageBoxPanelLarge);
        this.messageBox.setFont(this.sizes.fontLarge);
        this.unlockButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setFont(this.sizes.fontBoldLarge);
        this.zoomButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setFont(this.sizes.fontBoldLarge);
        this.controlPanel.setMaximumSize(this.sizes.controlPanelLarge);
        this.controlPanel.setMinimumSize(this.sizes.controlPanelLarge);
        this.controlPanel.setPreferredSize(this.sizes.controlPanelLarge);
        for (int i2 = 0; i2 < this.controlButtons.length; ++i2) {
            Dimension d = new Dimension((int)(this.sizes.controlButtonPerLetterWidthLarge * (double)this.controlButtons[i2].getText().length()), this.sizes.controlButtonHeightLarge);
            this.controlButtons[i2].setMaximumSize(d);
            this.controlButtons[i2].setMinimumSize(d);
            this.controlButtons[i2].setPreferredSize(d);
            this.controlButtons[i2].setFont(this.sizes.fontBoldLarge);
        }
        Dimension d = new Dimension(this.sizes.quitButtonWidthLarge, this.sizes.controlButtonHeightLarge);
        this.quit.setMaximumSize(d);
        this.quit.setMinimumSize(d);
        this.quit.setPreferredSize(d);
        this.portPinConnectionsPanel.setMaximumSize(this.sizes.portPinConnectionsPanelLarge);
        this.portPinConnectionsPanel.setMinimumSize(this.sizes.portPinConnectionsPanelLarge);
        this.portPinConnectionsPanel.setPreferredSize(this.sizes.portPinConnectionsPanelLarge);
        this.port0Panel.setMaximumSize(this.sizes.portPanelLarge);
        this.port0Panel.setMinimumSize(this.sizes.portPanelLarge);
        this.port0Panel.setPreferredSize(this.sizes.portPanelLarge);
        this.port1Panel.setMaximumSize(this.sizes.portPanelLarge);
        this.port1Panel.setMinimumSize(this.sizes.portPanelLarge);
        this.port1Panel.setPreferredSize(this.sizes.portPanelLarge);
        this.port2Panel.setMaximumSize(this.sizes.portPanelLarge);
        this.port2Panel.setMinimumSize(this.sizes.portPanelLarge);
        this.port2Panel.setPreferredSize(this.sizes.portPanelLarge);
        this.port3Panel.setMaximumSize(this.sizes.portPanelLarge);
        this.port3Panel.setMinimumSize(this.sizes.portPanelLarge);
        this.port3Panel.setPreferredSize(this.sizes.portPanelLarge);
        this.noTargetBoardLabel.setFont(this.sizes.notTargetBoardLabelFontLarge);
        this.targetBoardPanel.setMaximumSize(this.sizes.targetBoardLarge);
        this.targetBoardPanel.setMinimumSize(this.sizes.targetBoardLarge);
        this.targetBoardPanel.setPreferredSize(this.sizes.targetBoardLarge);
        this.targetBoardScrollPane.setPreferredSize(this.sizes.targetBoardLarge);
        if (this.ppDesc != null) {
            this.ppDesc.setSize(false);
        }
        if ((board = this.cpu.memory.getTargetBoard()) != null) {
            board.setTargetBoardGraphicsSize(false);
        }
        this.externalFrame.pack();
    }

    void zoomOut() {
        TargetBoard board;
        int i;
        this.bitFieldInfoButton.setSize(true);
        this.sysClockField.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setFont(this.sizes.fontSmall);
        this.microcontroller.setMaximumSize(this.sizes.microSmall);
        this.microcontroller.setMinimumSize(this.sizes.microSmall);
        this.microcontroller.setPreferredSize(this.sizes.microSmall);
        this.microcontrollerLabel.setFont(this.sizes.microLabelSmall);
        this.sysClockLabel.setFont(this.sizes.fontBoldSmall);
        this.copyright.setFont(this.sizes.copyrightFontSmall);
        for (i = 0; i < this.bitFields.length; ++i) {
            this.bitFields[i].setMaximumSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setMinimumSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setPreferredSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setFont(this.sizes.fontSmall);
        }
        for (i = 0; i < this.eightBitFields.length; ++i) {
            this.eightBitFields[i].setMaximumSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setMinimumSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setPreferredSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setFont(this.sizes.fontSmall);
        }
        for (i = 0; i < this.labels.length; ++i) {
            this.labels[i].setFont(this.sizes.fontBoldSmall);
        }
        this.pc.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setFont(this.sizes.fontSmall);
        this.memoryWindow.makeSmall(true);
        this.memoryWindowAddressField.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setFont(this.sizes.fontSmall);
        this.memoryTypeButton.setMaximumSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setMinimumSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setPreferredSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setFont(this.sizes.fontBoldSmall);
        this.removeAllBreakpointsButton.setMaximumSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setMinimumSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setPreferredSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setFont(this.sizes.fontBoldSmall);
        this.updateFreqPanel.setLabelFont(this.sizes.fontBoldSmall);
        this.updateFreqPanel.setMenuFont(this.sizes.comboBoxFontSmall);
        this.updateFreqPanel.setUpdateFreqComboBoxSize(this.sizes.updateFreqComboBoxSmall);
        this.assembly.setMaximumSize(this.sizes.assemblySmall);
        this.assembly.setMinimumSize(this.sizes.assemblySmall);
        this.assembly.setPreferredSize(this.sizes.assemblySmall);
        this.assemblyCodeBoxPanel.setMaximumSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBoxPanel.setMinimumSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBoxPanel.setPreferredSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBox.setFontSize(true);
        this.messageBoxPanel.setMaximumSize(this.sizes.messageBoxPanelSmall);
        this.messageBoxPanel.setMinimumSize(this.sizes.messageBoxPanelSmall);
        this.messageBoxPanel.setPreferredSize(this.sizes.messageBoxPanelSmall);
        this.messageBox.setFont(this.sizes.fontSmall);
        this.unlockButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setFont(this.sizes.fontBoldSmall);
        this.zoomButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setFont(this.sizes.fontBoldSmall);
        this.controlPanel.setMaximumSize(this.sizes.controlPanelSmall);
        this.controlPanel.setMinimumSize(this.sizes.controlPanelSmall);
        this.controlPanel.setPreferredSize(this.sizes.controlPanelSmall);
        for (int i2 = 0; i2 < this.controlButtons.length; ++i2) {
            Dimension d = new Dimension((int)(this.sizes.controlButtonPerLetterWidthSmall * (double)this.controlButtons[i2].getText().length()), this.sizes.controlButtonHeightSmall);
            this.controlButtons[i2].setMaximumSize(d);
            this.controlButtons[i2].setMinimumSize(d);
            this.controlButtons[i2].setPreferredSize(d);
            this.controlButtons[i2].setFont(this.sizes.fontBoldSmall);
        }
        Dimension d = new Dimension(this.sizes.quitButtonWidthSmall, this.sizes.controlButtonHeightSmall);
        this.quit.setMaximumSize(d);
        this.quit.setMinimumSize(d);
        this.quit.setPreferredSize(d);
        this.portPinConnectionsPanel.setMaximumSize(this.sizes.portPinConnectionsPanelSmall);
        this.portPinConnectionsPanel.setMinimumSize(this.sizes.portPinConnectionsPanelSmall);
        this.portPinConnectionsPanel.setPreferredSize(this.sizes.portPinConnectionsPanelSmall);
        this.port0Panel.setMaximumSize(this.sizes.portPanelSmall);
        this.port0Panel.setMinimumSize(this.sizes.portPanelSmall);
        this.port0Panel.setPreferredSize(this.sizes.portPanelSmall);
        this.port1Panel.setMaximumSize(this.sizes.portPanelSmall);
        this.port1Panel.setMinimumSize(this.sizes.portPanelSmall);
        this.port1Panel.setPreferredSize(this.sizes.portPanelSmall);
        this.port2Panel.setMaximumSize(this.sizes.portPanelSmall);
        this.port2Panel.setMinimumSize(this.sizes.portPanelSmall);
        this.port2Panel.setPreferredSize(this.sizes.portPanelSmall);
        this.port3Panel.setMaximumSize(this.sizes.portPanelSmall);
        this.port3Panel.setMinimumSize(this.sizes.portPanelSmall);
        this.port3Panel.setPreferredSize(this.sizes.portPanelSmall);
        this.noTargetBoardLabel.setFont(this.sizes.notTargetBoardLabelFontSmall);
        this.targetBoardPanel.setMaximumSize(this.sizes.targetBoardSmall);
        this.targetBoardPanel.setMinimumSize(this.sizes.targetBoardSmall);
        this.targetBoardPanel.setPreferredSize(this.sizes.targetBoardSmall);
        this.targetBoardScrollPane.setPreferredSize(this.sizes.targetBoardSmall);
        if (this.ppDesc != null) {
            this.ppDesc.setSize(true);
        }
        if ((board = this.cpu.memory.getTargetBoard()) != null) {
            board.setTargetBoardGraphicsSize(true);
        }
        this.externalFrame.pack();
    }

    private void zoomWindowButtonPressed() {
        if (this.settings.isSmall()) {
            this.settings.setSmall(false);
            this.zoomButton.setText("-");
            this.zoomButton.setToolTipText("Zoom out main window");
            this.zoomIn();
        } else {
            this.settings.setSmall(true);
            this.zoomButton.setText("+");
            this.zoomButton.setToolTipText("Zoom in main window");
            this.zoomOut();
        }
    }

    private void openUnlockedAssemblyCodeBox() {
        if (this.unlockedAssemblyCodeFrame == null) {
            this.unlockedAssemblyCodeFrame = new UnlockedAssemblyCodeFrame(this.isDI, this);
        }
        this.assemblyCodeBoxPanel.remove(this.assemblyCodeBox);
        this.assembly.repaint();
        this.unlockedAssemblyCodeFrame.addSourceWindow(this.assemblyCodeBox);
        this.unlockedAssemblyCodeFrame.setVisible(true);
    }

    void unlockedAssemblyCodeBoxClosed() {
        this.assemblyCodeBoxPanel.remove(this.assemblyCodeBox);
        this.assemblyCodeBoxPanel.setViewportView(this.assemblyCodeBox);
        this.assemblyCodeBox.requestFocusInWindow();
    }

    private void setRegistersToolTipText() {
        try {
            this.R0.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(0)));
            this.R1.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(1)));
            this.R2.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(2)));
            this.R3.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(3)));
            this.R4.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(4)));
            this.R5.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(5)));
            this.R6.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(6)));
            this.R7.setToolTipText("addr: " + Text.inHex(this.cpu.memory.getRegisterAddress(7)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.memoryTypeButton = new JButton();
        this.microcontroller = new JPanel();
        this.R7 = new JLabel();
        this.R6 = new JLabel();
        this.R5 = new JLabel();
        this.R4 = new JLabel();
        this.R3 = new JLabel();
        this.R2 = new JLabel();
        this.R1 = new JLabel();
        this.R0 = new JLabel();
        this.register7 = new JTextField();
        this.register6 = new JTextField();
        this.register5 = new JTextField();
        this.register4 = new JTextField();
        this.register3 = new JTextField();
        this.register2 = new JTextField();
        this.register1 = new JTextField();
        this.register0 = new JTextField();
        this.accLabel = new JLabel();
        this.acc = new JTextField();
        this.pswLabel = new JLabel();
        this.port1 = new JTextField();
        this.port1Label = new JLabel();
        this.port1pins = new JTextField();
        this.latchLabel = new JLabel();
        this.addrLabel = new JLabel();
        this.microcontrollerLabel = new JLabel();
        this.port2Label = new JLabel();
        this.port2 = new JTextField();
        this.port2pins = new JTextField();
        this.port3pins = new JTextField();
        this.port0pins = new JTextField();
        this.port3 = new JTextField();
        this.port0 = new JTextField();
        this.port3Label = new JLabel();
        this.port0Label = new JLabel();
        this.pinsLabel = new JLabel();
        this.memoryWindowByteField = new JTextField();
        this.memoryWindowAddressField = new JTextField();
        this.addLabel = new JLabel();
        this.dataLabel = new JLabel();
        this.th0 = new JTextField();
        this.th0label = new JLabel();
        this.tl0label = new JLabel();
        this.tl0 = new JTextField();
        this.tmod = new JTextField();
        this.tmodLabel = new JLabel();
        this.th1 = new JTextField();
        this.tl1 = new JTextField();
        this.th1label = new JLabel();
        this.tl1label = new JLabel();
        this.tconLabel = new JLabel();
        this.tcon = new JTextField();
        this.scon = new JTextField();
        this.sconLabel = new JLabel();
        this.sbufLabel = new JLabel();
        this.sbuf = new JTextField();
        this.txd = new JTextField();
        this.rxdLabel = new JLabel();
        this.txdLabel = new JLabel();
        this.sbufReadOnly = new JTextField();
        this.sbufRonlyLabel = new JLabel();
        this.sbufWonlyLabel = new JLabel();
        this.rxd = new JTextField();
        this.pc = new JTextField();
        this.pcLabel = new JLabel();
        this.psw = new JTextField();
        this.spLabel = new JLabel();
        this.sp = new JTextField();
        this.ipLabel = new JLabel();
        this.ip = new JTextField();
        this.ieLabel = new JLabel();
        this.ie = new JTextField();
        this.bitfieldPanel = new JPanel();
        this.bit0 = new JTextField();
        this.bit1 = new JTextField();
        this.bit2 = new JTextField();
        this.bit3 = new JTextField();
        this.bit4 = new JTextField();
        this.bit5 = new JTextField();
        this.bit6 = new JTextField();
        this.bit7 = new JTextField();
        this.bitfieldByteAddress = new JTextField();
        this.copyright = new JLabel();
        this.dph = new JTextField();
        this.dphLabel = new JLabel();
        this.dpl = new JTextField();
        this.dplLabel = new JLabel();
        this.b = new JTextField();
        this.bLabel = new JLabel();
        this.pcon = new JTextField();
        this.pconLabel = new JLabel();
        this.assembly = new JPanel();
        this.messageBoxPanel = new JScrollPane();
        this.messageBox = new JTextField();
        this.portPinConnectionsPanel = new JPanel();
        this.port0Panel = new JPanel();
        this.port1Panel = new JPanel();
        this.port2Panel = new JPanel();
        this.port3Panel = new JPanel();
        this.controlPanel = new JPanel();
        this.run = new JButton();
        this.copy = new JButton();
        this.paste = new JButton();
        this.quit = new Quit();
        this.newFile = new JButton();
        this.fileOpen = new JButton();
        this.reset = new JButton();
        this.step = new JButton();
        this.fileSave = new JButton();
        this.assemblyCodeBoxPanel = new JScrollPane();
        this.sysClockLabel = new JLabel("System Clock (MHz)");
        this.setLayout(new GridBagLayout());
        this.microcontroller.setLayout(new GridBagLayout());
        this.microcontroller.setBackground(new Color(255, 255, 255));
        this.microcontroller.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(51, 102, 255), 2)));
        this.microcontroller.setMaximumSize(new Dimension(420, 480));
        this.microcontroller.setMinimumSize(new Dimension(420, 480));
        this.microcontroller.setPreferredSize(new Dimension(420, 480));
        this.R7.setText("R7");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R7, gbc);
        this.R6.setText("R6");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 3;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R6, gbc);
        this.R5.setText("R5");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 4;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R5, gbc);
        this.R4.setText("R4");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 5;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R4, gbc);
        this.R3.setText("R3");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 6;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R3, gbc);
        this.R2.setText("R2");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 7;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R2, gbc);
        this.R1.setText("R1");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 8;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R1, gbc);
        this.R0.setText("R0");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 9;
        gbc.insets = this.sizes.registerInsets;
        this.microcontroller.add((Component)this.R0, gbc);
        this.register7.setFont(new Font("Monospaced", 0, 12));
        this.register7.setHorizontalAlignment(4);
        this.register7.setText("0x00");
        this.register7.setMaximumSize(new Dimension(40, 19));
        this.register7.setMinimumSize(new Dimension(40, 19));
        this.register7.setPreferredSize(new Dimension(40, 19));
        this.register7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register7ActionPerformed(evt);
            }
        });
        this.register7.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register7FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register7, gbc);
        this.register6.setFont(new Font("Monospaced", 0, 12));
        this.register6.setHorizontalAlignment(4);
        this.register6.setText("0x00");
        this.register6.setMaximumSize(new Dimension(40, 19));
        this.register6.setMinimumSize(new Dimension(40, 19));
        this.register6.setPreferredSize(new Dimension(40, 19));
        this.register6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register6ActionPerformed(evt);
            }
        });
        this.register6.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register6FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register6, gbc);
        this.register5.setFont(new Font("Monospaced", 0, 12));
        this.register5.setHorizontalAlignment(4);
        this.register5.setText("0x00");
        this.register5.setMaximumSize(new Dimension(40, 19));
        this.register5.setMinimumSize(new Dimension(40, 19));
        this.register5.setPreferredSize(new Dimension(40, 19));
        this.register5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register5ActionPerformed(evt);
            }
        });
        this.register5.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register5FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register5, gbc);
        this.register4.setFont(new Font("Monospaced", 0, 12));
        this.register4.setHorizontalAlignment(4);
        this.register4.setText("0x00");
        this.register4.setMaximumSize(new Dimension(40, 19));
        this.register4.setMinimumSize(new Dimension(40, 19));
        this.register4.setPreferredSize(new Dimension(40, 19));
        this.register4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register4ActionPerformed(evt);
            }
        });
        this.register4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register4FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register4, gbc);
        this.register3.setFont(new Font("Monospaced", 0, 12));
        this.register3.setHorizontalAlignment(4);
        this.register3.setText("0x00");
        this.register3.setMaximumSize(new Dimension(40, 19));
        this.register3.setMinimumSize(new Dimension(40, 19));
        this.register3.setPreferredSize(new Dimension(40, 19));
        this.register3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register3ActionPerformed(evt);
            }
        });
        this.register3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register3FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register3, gbc);
        this.register2.setFont(new Font("Monospaced", 0, 12));
        this.register2.setHorizontalAlignment(4);
        this.register2.setText("0x00");
        this.register2.setMaximumSize(new Dimension(40, 19));
        this.register2.setMinimumSize(new Dimension(40, 19));
        this.register2.setPreferredSize(new Dimension(40, 19));
        this.register2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register2ActionPerformed(evt);
            }
        });
        this.register2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register2FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register2, gbc);
        this.register1.setFont(new Font("Monospaced", 0, 12));
        this.register1.setHorizontalAlignment(4);
        this.register1.setText("0x00");
        this.register1.setMaximumSize(new Dimension(40, 19));
        this.register1.setMinimumSize(new Dimension(40, 19));
        this.register1.setPreferredSize(new Dimension(40, 19));
        this.register1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register1ActionPerformed(evt);
            }
        });
        this.register1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register1FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register1, gbc);
        this.register0.setFont(new Font("Monospaced", 0, 12));
        this.register0.setHorizontalAlignment(4);
        this.register0.setText("0x00");
        this.register0.setMaximumSize(new Dimension(40, 19));
        this.register0.setMinimumSize(new Dimension(40, 19));
        this.register0.setPreferredSize(new Dimension(40, 19));
        this.register0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.register0ActionPerformed(evt);
            }
        });
        this.register0.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.register0FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.register0, gbc);
        this.accLabel.setText("ACC");
        this.accLabel.setToolTipText("addr: " + Text.inHex(224));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.accLabel, gbc);
        this.acc.setFont(new Font("Monospaced", 0, 12));
        this.acc.setHorizontalAlignment(4);
        this.acc.setText("0x00");
        this.acc.setMaximumSize(new Dimension(40, 19));
        this.acc.setMinimumSize(new Dimension(40, 19));
        this.acc.setPreferredSize(new Dimension(40, 19));
        this.acc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.accActionPerformed(evt);
            }
        });
        this.acc.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.accFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.acc, gbc);
        this.pswLabel.setText("PSW");
        this.pswLabel.setToolTipText("addr: " + Text.inHex(208));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 4;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.pswLabel, gbc);
        this.port1.setFont(new Font("Monospaced", 0, 12));
        this.port1.setHorizontalAlignment(4);
        this.port1.setText("0xFF");
        this.port1.setMaximumSize(new Dimension(40, 19));
        this.port1.setMinimumSize(new Dimension(40, 19));
        this.port1.setPreferredSize(new Dimension(40, 19));
        this.port1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.port1ActionPerformed(evt);
            }
        });
        this.port1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.port1FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 11;
        this.microcontroller.add((Component)this.port1, gbc);
        this.port1Label.setText("P1");
        this.port1Label.setToolTipText("addr: " + Text.inHex(144));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 11;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.port1Label, gbc);
        this.port1pins.setEditable(false);
        this.port1pins.setFont(new Font("Monospaced", 0, 12));
        this.port1pins.setHorizontalAlignment(4);
        this.port1pins.setText("0xFF");
        this.port1pins.setMaximumSize(new Dimension(40, 19));
        this.port1pins.setMinimumSize(new Dimension(40, 19));
        this.port1pins.setPreferredSize(new Dimension(40, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 11;
        this.microcontroller.add((Component)this.port1pins, gbc);
        this.latchLabel.setHorizontalAlignment(0);
        this.latchLabel.setText("bits");
        this.latchLabel.setToolTipText("internal port latches");
        this.latchLabel.setVerticalAlignment(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        this.microcontroller.add((Component)this.latchLabel, gbc);
        this.addrLabel.setHorizontalAlignment(0);
        if (this.settings.isDataMemoryDisplayed()) {
            this.addrLabel.setText("Modify RAM");
        } else {
            this.addrLabel.setText("Modify Code");
        }
        this.addrLabel.setToolTipText("Enter the address you want to modify in the blue box");
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 13;
        gbc.gridwidth = 4;
        this.microcontroller.add((Component)this.addrLabel, gbc);
        this.microcontrollerLabel.setFont(new Font("Dialog", 1, 14));
        this.microcontrollerLabel.setText("8051");
        this.microcontrollerLabel.setForeground(Color.BLUE);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 9;
        gbc.gridwidth = 4;
        gbc.gridheight = 3;
        gbc.anchor = 13;
        this.microcontroller.add((Component)this.microcontrollerLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 13;
        this.microcontroller.add((Component)this.sysClockLabel, gbc);
        this.port2Label.setText("P2");
        this.port2Label.setToolTipText("addr: " + Text.inHex(160));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 10;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.port2Label, gbc);
        this.port2.setFont(new Font("Monospaced", 0, 12));
        this.port2.setHorizontalAlignment(4);
        this.port2.setText("0xFF");
        this.port2.setMaximumSize(new Dimension(40, 19));
        this.port2.setMinimumSize(new Dimension(40, 19));
        this.port2.setPreferredSize(new Dimension(40, 19));
        this.port2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.port2ActionPerformed(evt);
            }
        });
        this.port2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.port2FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 10;
        this.microcontroller.add((Component)this.port2, gbc);
        this.port2pins.setEditable(false);
        this.port2pins.setFont(new Font("Monospaced", 0, 12));
        this.port2pins.setHorizontalAlignment(4);
        this.port2pins.setText("0xFF");
        this.port2pins.setMaximumSize(new Dimension(40, 19));
        this.port2pins.setMinimumSize(new Dimension(40, 19));
        this.port2pins.setPreferredSize(new Dimension(40, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        this.microcontroller.add((Component)this.port2pins, gbc);
        this.port3pins.setEditable(false);
        this.port3pins.setFont(new Font("Monospaced", 0, 12));
        this.port3pins.setHorizontalAlignment(4);
        this.port3pins.setText("0xFF");
        this.port3pins.setMaximumSize(new Dimension(40, 19));
        this.port3pins.setMinimumSize(new Dimension(40, 19));
        this.port3pins.setPreferredSize(new Dimension(40, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        this.microcontroller.add((Component)this.port3pins, gbc);
        this.port0pins.setEditable(false);
        this.port0pins.setFont(new Font("Monospaced", 0, 12));
        this.port0pins.setHorizontalAlignment(4);
        this.port0pins.setText("0xFF");
        this.port0pins.setMaximumSize(new Dimension(40, 19));
        this.port0pins.setMinimumSize(new Dimension(40, 19));
        this.port0pins.setPreferredSize(new Dimension(40, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 12;
        this.microcontroller.add((Component)this.port0pins, gbc);
        this.port3.setFont(new Font("Monospaced", 0, 12));
        this.port3.setHorizontalAlignment(4);
        this.port3.setText("0xFF");
        this.port3.setMaximumSize(new Dimension(40, 19));
        this.port3.setMinimumSize(new Dimension(40, 19));
        this.port3.setPreferredSize(new Dimension(40, 19));
        this.port3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.port3ActionPerformed(evt);
            }
        });
        this.port3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.port3FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        this.microcontroller.add((Component)this.port3, gbc);
        this.port0.setFont(new Font("Monospaced", 0, 12));
        this.port0.setHorizontalAlignment(4);
        this.port0.setText("0xFF");
        this.port0.setMaximumSize(new Dimension(40, 19));
        this.port0.setMinimumSize(new Dimension(40, 19));
        this.port0.setPreferredSize(new Dimension(40, 19));
        this.port0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.port0ActionPerformed(evt);
            }
        });
        this.port0.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.port0FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 12;
        this.microcontroller.add((Component)this.port0, gbc);
        this.port3Label.setText("P3");
        this.port3Label.setToolTipText("addr: " + Text.inHex(176));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 9;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.microcontroller.add((Component)this.port3Label, gbc);
        this.port0Label.setText("P0");
        this.port0Label.setToolTipText("addr: " + Text.inHex(128));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 12;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.port0Label, gbc);
        this.memoryWindow = new MemoryWindow(this.cpu.memory.getMemoryWindow(this.settings.isDataMemoryDisplayed(), this.settings.getCodeWindowStartAddress()), this.settings.isSmall(), this.settings.isDataMemoryDisplayed());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 16;
        gbc.gridwidth = 12;
        gbc.gridheight = 8;
        gbc.insets = new Insets(2, 0, 2, 0);
        this.microcontroller.add((Component)this.memoryWindow, gbc);
        this.pinsLabel.setHorizontalAlignment(0);
        this.pinsLabel.setText("pins");
        this.pinsLabel.setToolTipText("external port pins");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        this.microcontroller.add((Component)this.pinsLabel, gbc);
        this.memoryWindowByteField.setFont(new Font("Monospaced", 0, 12));
        this.memoryWindowByteField.setHorizontalAlignment(4);
        this.memoryWindowByteField.setText("0x00");
        this.memoryWindowByteField.setMaximumSize(new Dimension(40, 19));
        this.memoryWindowByteField.setMinimumSize(new Dimension(40, 19));
        this.memoryWindowByteField.setPreferredSize(new Dimension(40, 19));
        this.memoryWindowByteField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.memoryWindowByteFieldActionPerformed(evt);
            }
        });
        this.memoryWindowByteField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.memoryWindowByteFieldFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 14;
        this.microcontroller.add((Component)this.memoryWindowByteField, gbc);
        this.memoryWindowAddressField.setFont(new Font("Monospaced", 0, 12));
        this.memoryWindowAddressField.setHorizontalAlignment(4);
        if (this.settings.isDataMemoryDisplayed()) {
            this.memoryWindowAddressField.setText("0x00");
        } else {
            this.memoryWindowAddressField.setText(Text.inHex(this.settings.getCodeWindowStartAddress(), true, 4));
        }
        this.memoryWindowAddressField.setBorder(new LineBorder(new Color(153, 153, 255), 2));
        this.memoryWindowAddressField.setMaximumSize(new Dimension(60, 19));
        this.memoryWindowAddressField.setMinimumSize(new Dimension(60, 19));
        this.memoryWindowAddressField.setPreferredSize(new Dimension(60, 19));
        this.memoryWindowAddressField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.memoryWindowAddressFieldActionPerformed(evt);
            }
        });
        this.memoryWindowAddressField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.memoryWindowAddressFieldFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 14;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.memoryWindowAddressField, gbc);
        this.addLabel.setHorizontalAlignment(4);
        this.addLabel.setText("addr");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 14;
        gbc.gridwidth = 3;
        gbc.anchor = 13;
        this.microcontroller.add((Component)this.addLabel, gbc);
        this.dataLabel.setHorizontalAlignment(2);
        this.dataLabel.setText("value");
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 14;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.dataLabel, gbc);
        this.memoryTypeButton.setFont(new Font("Monospaced", 1, 12));
        if (this.settings.isDataMemoryDisplayed()) {
            this.memoryTypeButton.setText("Data Memory");
        } else {
            this.memoryTypeButton.setText("Code Memory");
        }
        this.memoryTypeButton.setToolTipText("Click to change between data memory and code memory.");
        this.memoryTypeButton.setBorder(new BevelBorder(0));
        this.memoryTypeButton.setMaximumSize(new Dimension(90, 19));
        this.memoryTypeButton.setMinimumSize(new Dimension(90, 19));
        this.memoryTypeButton.setPreferredSize(new Dimension(90, 19));
        this.memoryTypeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.memoryTypeButtonMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 14;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.memoryTypeButton, gbc);
        this.th0.setFont(new Font("Monospaced", 0, 12));
        this.th0.setHorizontalAlignment(4);
        this.th0.setText("0x00");
        this.th0.setMaximumSize(new Dimension(40, 19));
        this.th0.setMinimumSize(new Dimension(40, 19));
        this.th0.setPreferredSize(new Dimension(40, 19));
        this.th0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.th0ActionPerformed(evt);
            }
        });
        this.th0.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.th0FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.th0, gbc);
        this.th0label.setText("TH0");
        this.th0label.setToolTipText("addr: " + Text.inHex(140));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.microcontroller.add((Component)this.th0label, gbc);
        this.tl0label.setText("TL0");
        this.tl0label.setToolTipText("addr: " + Text.inHex(138));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        this.microcontroller.add((Component)this.tl0label, gbc);
        this.tl0.setFont(new Font("Monospaced", 0, 12));
        this.tl0.setHorizontalAlignment(4);
        this.tl0.setText("0x00");
        this.tl0.setMaximumSize(new Dimension(40, 19));
        this.tl0.setMinimumSize(new Dimension(40, 19));
        this.tl0.setPreferredSize(new Dimension(40, 19));
        this.tl0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.tl0ActionPerformed(evt);
            }
        });
        this.tl0.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.tl0FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.tl0, gbc);
        this.tmod.setFont(new Font("Monospaced", 0, 12));
        this.tmod.setHorizontalAlignment(4);
        this.tmod.setText("0x00");
        this.tmod.setMaximumSize(new Dimension(40, 19));
        this.tmod.setMinimumSize(new Dimension(40, 19));
        this.tmod.setPreferredSize(new Dimension(40, 19));
        this.tmod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.tmodActionPerformed(evt);
            }
        });
        this.tmod.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.tmodFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 5;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.tmod, gbc);
        this.tmodLabel.setText("TMOD");
        this.tmodLabel.setToolTipText("addr: " + Text.inHex(137));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 5;
        this.microcontroller.add((Component)this.tmodLabel, gbc);
        this.th1.setFont(new Font("Monospaced", 0, 12));
        this.th1.setHorizontalAlignment(4);
        this.th1.setText("0x00");
        this.th1.setMaximumSize(new Dimension(40, 19));
        this.th1.setMinimumSize(new Dimension(40, 19));
        this.th1.setPreferredSize(new Dimension(40, 19));
        this.th1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.th1ActionPerformed(evt);
            }
        });
        this.th1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.th1FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 9;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.th1, gbc);
        this.tl1.setFont(new Font("Monospaced", 0, 12));
        this.tl1.setHorizontalAlignment(4);
        this.tl1.setText("0x00");
        this.tl1.setMaximumSize(new Dimension(40, 19));
        this.tl1.setMinimumSize(new Dimension(40, 19));
        this.tl1.setPreferredSize(new Dimension(40, 19));
        this.tl1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.tl1ActionPerformed(evt);
            }
        });
        this.tl1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.tl1FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 9;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.tl1, gbc);
        this.th1label.setText("TH1");
        this.th1label.setToolTipText("addr: " + Text.inHex(141));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 8;
        this.microcontroller.add((Component)this.th1label, gbc);
        this.tl1label.setText("TL1");
        this.tl1label.setToolTipText("addr: " + Text.inHex(139));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 8;
        this.microcontroller.add((Component)this.tl1label, gbc);
        this.tconLabel.setText("TCON");
        this.tconLabel.setToolTipText("addr: " + Text.inHex(136));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 6;
        this.microcontroller.add((Component)this.tconLabel, gbc);
        this.tcon.setFont(new Font("Monospaced", 0, 12));
        this.tcon.setHorizontalAlignment(4);
        this.tcon.setText("0x00");
        this.tcon.setMaximumSize(new Dimension(40, 19));
        this.tcon.setMinimumSize(new Dimension(40, 19));
        this.tcon.setPreferredSize(new Dimension(40, 19));
        this.tcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.tconActionPerformed(evt);
            }
        });
        this.tcon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.tconFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 6;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.tcon, gbc);
        this.scon.setFont(new Font("Monospaced", 0, 12));
        this.scon.setHorizontalAlignment(4);
        this.scon.setText("0x00");
        this.scon.setMaximumSize(new Dimension(40, 19));
        this.scon.setMinimumSize(new Dimension(40, 19));
        this.scon.setPreferredSize(new Dimension(40, 19));
        this.scon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.sconActionPerformed(evt);
            }
        });
        this.scon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.sconFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.scon, gbc);
        this.sconLabel.setText("SCON");
        this.sconLabel.setToolTipText("addr: " + Text.inHex(152));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        this.microcontroller.add((Component)this.sconLabel, gbc);
        this.sbufLabel.setText("SBUF");
        this.sbufLabel.setToolTipText("addr: " + Text.inHex(153));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 15;
        this.microcontroller.add((Component)this.sbufLabel, gbc);
        this.sbuf.setFont(new Font("Monospaced", 0, 12));
        this.sbuf.setHorizontalAlignment(4);
        this.sbuf.setText("0x00");
        this.sbuf.setMaximumSize(new Dimension(40, 19));
        this.sbuf.setMinimumSize(new Dimension(40, 19));
        this.sbuf.setPreferredSize(new Dimension(40, 19));
        this.sbuf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.sbufActionPerformed(evt);
            }
        });
        this.sbuf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.sbufFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 11;
        this.microcontroller.add((Component)this.sbuf, gbc);
        this.txd.setEditable(false);
        this.txd.setFont(new Font("Monospaced", 0, 12));
        this.txd.setHorizontalAlignment(4);
        this.txd.setText("1");
        this.txd.setMaximumSize(new Dimension(15, 19));
        this.txd.setMinimumSize(new Dimension(15, 19));
        this.txd.setPreferredSize(new Dimension(15, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.microcontroller.add((Component)this.txd, gbc);
        this.rxdLabel.setText("RXD");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 15;
        this.microcontroller.add((Component)this.rxdLabel, gbc);
        this.txdLabel.setText("TXD");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 15;
        this.microcontroller.add((Component)this.txdLabel, gbc);
        this.sbufReadOnly.setEditable(false);
        this.sbufReadOnly.setFont(new Font("Monospaced", 0, 12));
        this.sbufReadOnly.setHorizontalAlignment(4);
        this.sbufReadOnly.setText("0x00");
        this.sbufReadOnly.setMaximumSize(new Dimension(40, 19));
        this.sbufReadOnly.setMinimumSize(new Dimension(40, 19));
        this.sbufReadOnly.setPreferredSize(new Dimension(40, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 11;
        this.microcontroller.add((Component)this.sbufReadOnly, gbc);
        this.sbufRonlyLabel.setText("R/O");
        this.sbufRonlyLabel.setToolTipText("read-only");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 15;
        this.microcontroller.add((Component)this.sbufRonlyLabel, gbc);
        this.sbufWonlyLabel.setText("W/O");
        this.sbufWonlyLabel.setToolTipText("write-only");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 15;
        this.microcontroller.add((Component)this.sbufWonlyLabel, gbc);
        this.rxd.setEditable(false);
        this.rxd.setFont(new Font("Monospaced", 0, 12));
        this.rxd.setHorizontalAlignment(4);
        this.rxd.setText("1");
        this.rxd.setMaximumSize(new Dimension(15, 19));
        this.rxd.setMinimumSize(new Dimension(15, 19));
        this.rxd.setPreferredSize(new Dimension(15, 19));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.microcontroller.add((Component)this.rxd, gbc);
        this.pc.setFont(new Font("Monospaced", 0, 12));
        this.pc.setHorizontalAlignment(4);
        this.pc.setText("0x0000");
        this.pc.setMaximumSize(new Dimension(60, 19));
        this.pc.setMinimumSize(new Dimension(60, 19));
        this.pc.setPreferredSize(new Dimension(60, 19));
        this.pc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.pcActionPerformed(evt);
            }
        });
        this.pc.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.pcFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 11;
        gbc.gridheight = 2;
        gbc.gridwidth = 2;
        this.microcontroller.add((Component)this.pc, gbc);
        this.pcLabel.setText("PC");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 10;
        gbc.gridheight = 2;
        this.microcontroller.add((Component)this.pcLabel, gbc);
        this.psw.setFont(new Font("Monospaced", 0, 12));
        this.psw.setHorizontalAlignment(4);
        this.psw.setText("0x00");
        this.psw.setMaximumSize(new Dimension(40, 19));
        this.psw.setMinimumSize(new Dimension(40, 19));
        this.psw.setPreferredSize(new Dimension(40, 19));
        this.psw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.pswActionPerformed(evt);
            }
        });
        this.psw.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.pswFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 4;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.psw, gbc);
        this.spLabel.setText("SP");
        this.spLabel.setToolTipText("addr: " + Text.inHex(129));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 10;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.spLabel, gbc);
        this.sp.setFont(new Font("Monospaced", 0, 12));
        this.sp.setHorizontalAlignment(4);
        this.sp.setText("0x07");
        this.sp.setMaximumSize(new Dimension(40, 19));
        this.sp.setMinimumSize(new Dimension(40, 19));
        this.sp.setPreferredSize(new Dimension(40, 19));
        this.sp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.spActionPerformed(evt);
            }
        });
        this.sp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.spFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 10;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.sp, gbc);
        this.ipLabel.setText("IP");
        this.ipLabel.setToolTipText("addr: " + Text.inHex(184));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 5;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.ipLabel, gbc);
        this.ip.setFont(new Font("Monospaced", 0, 12));
        this.ip.setHorizontalAlignment(4);
        this.ip.setText("0x00");
        this.ip.setMaximumSize(new Dimension(40, 19));
        this.ip.setMinimumSize(new Dimension(40, 19));
        this.ip.setPreferredSize(new Dimension(40, 19));
        this.ip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.ipActionPerformed(evt);
            }
        });
        this.ip.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.ipFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 5;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.ip, gbc);
        this.ieLabel.setText("IE");
        this.ieLabel.setToolTipText("addr: " + Text.inHex(168));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 6;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.ieLabel, gbc);
        this.ie.setFont(new Font("Monospaced", 0, 12));
        this.ie.setHorizontalAlignment(4);
        this.ie.setText("0x00");
        this.ie.setMaximumSize(new Dimension(40, 19));
        this.ie.setMinimumSize(new Dimension(40, 19));
        this.ie.setPreferredSize(new Dimension(40, 19));
        this.ie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.ieActionPerformed(evt);
            }
        });
        this.ie.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.ieFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 6;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.ie, gbc);
        this.bitfieldPanel.setLayout(new GridBagLayout());
        this.bitfieldPanel.setBackground(new Color(255, 255, 255));
        this.bit0.setFont(new Font("Monospaced", 0, 12));
        this.bit0.setHorizontalAlignment(0);
        this.bit0.setText("0");
        this.bit0.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit0.setMaximumSize(new Dimension(15, 19));
        this.bit0.setMinimumSize(new Dimension(15, 19));
        this.bit0.setPreferredSize(new Dimension(15, 19));
        this.bit0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit0ActionPerformed(evt);
            }
        });
        this.bit0.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit0FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        this.bitfieldPanel.add((Component)this.bit0, gbc);
        this.bit1.setFont(new Font("Monospaced", 0, 12));
        this.bit1.setHorizontalAlignment(0);
        this.bit1.setText("0");
        this.bit1.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit1.setMaximumSize(new Dimension(15, 19));
        this.bit1.setMinimumSize(new Dimension(15, 19));
        this.bit1.setPreferredSize(new Dimension(15, 19));
        this.bit1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit1ActionPerformed(evt);
            }
        });
        this.bit1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit1FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit1, gbc);
        this.bit2.setFont(new Font("Monospaced", 0, 12));
        this.bit2.setHorizontalAlignment(0);
        this.bit2.setText("0");
        this.bit2.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit2.setMaximumSize(new Dimension(15, 19));
        this.bit2.setMinimumSize(new Dimension(15, 19));
        this.bit2.setPreferredSize(new Dimension(15, 19));
        this.bit2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit2ActionPerformed(evt);
            }
        });
        this.bit2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit2FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit2, gbc);
        this.bit3.setFont(new Font("Monospaced", 0, 12));
        this.bit3.setHorizontalAlignment(0);
        this.bit3.setText("0");
        this.bit3.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit3.setMaximumSize(new Dimension(15, 19));
        this.bit3.setMinimumSize(new Dimension(15, 19));
        this.bit3.setPreferredSize(new Dimension(15, 19));
        this.bit3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit3ActionPerformed(evt);
            }
        });
        this.bit3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit3FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 4, 0, 1);
        this.bitfieldPanel.add((Component)this.bit3, gbc);
        this.bit4.setFont(new Font("Monospaced", 0, 12));
        this.bit4.setHorizontalAlignment(0);
        this.bit4.setText("0");
        this.bit4.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit4.setMaximumSize(new Dimension(15, 19));
        this.bit4.setMinimumSize(new Dimension(15, 19));
        this.bit4.setPreferredSize(new Dimension(15, 19));
        this.bit4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit4ActionPerformed(evt);
            }
        });
        this.bit4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit4FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 4);
        this.bitfieldPanel.add((Component)this.bit4, gbc);
        this.bit5.setFont(new Font("Monospaced", 0, 12));
        this.bit5.setHorizontalAlignment(0);
        this.bit5.setText("0");
        this.bit5.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit5.setMaximumSize(new Dimension(15, 19));
        this.bit5.setMinimumSize(new Dimension(15, 19));
        this.bit5.setPreferredSize(new Dimension(15, 19));
        this.bit5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit5ActionPerformed(evt);
            }
        });
        this.bit5.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit5FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit5, gbc);
        this.bit6.setFont(new Font("Monospaced", 0, 12));
        this.bit6.setHorizontalAlignment(0);
        this.bit6.setText("0");
        this.bit6.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit6.setMaximumSize(new Dimension(15, 19));
        this.bit6.setMinimumSize(new Dimension(15, 19));
        this.bit6.setPreferredSize(new Dimension(15, 19));
        this.bit6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit6ActionPerformed(evt);
            }
        });
        this.bit6.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit6FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit6, gbc);
        this.bit7.setFont(new Font("Monospaced", 0, 12));
        this.bit7.setHorizontalAlignment(0);
        this.bit7.setText("0");
        this.bit7.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit7.setMaximumSize(new Dimension(15, 19));
        this.bit7.setMinimumSize(new Dimension(15, 19));
        this.bit7.setPreferredSize(new Dimension(15, 19));
        this.bit7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bit7ActionPerformed(evt);
            }
        });
        this.bit7.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bit7FocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit7, gbc);
        this.bitfieldByteAddress.setFont(new Font("Monospaced", 0, 12));
        this.bitfieldByteAddress.setHorizontalAlignment(0);
        this.bitfieldByteAddress.setText(this.settings.getBitfieldByteAddressString());
        this.bitfieldByteAddress.setToolTipText("addr: " + Text.inHex(this.getBitFieldByteAddress()));
        this.updateBitFieldData();
        this.bitfieldByteAddress.setBorder(new LineBorder(new Color(153, 153, 255), 2));
        this.bitfieldByteAddress.setMaximumSize(new Dimension(40, 19));
        this.bitfieldByteAddress.setMinimumSize(new Dimension(40, 19));
        this.bitfieldByteAddress.setPreferredSize(new Dimension(40, 19));
        this.bitfieldByteAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bitfieldByteAddressActionPerformed(evt);
            }
        });
        this.bitfieldByteAddress.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bitfieldByteAddressFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 4);
        this.bitfieldPanel.add((Component)this.bitfieldByteAddress, gbc);
        String bitFieldInfoTitle = this.isDI ? "EdSim51DI - Bit Field Information" : "EdSim51SH - Bit Field Information";
        this.bitFieldInfoButton = new InfoButton(this, "This field displays the individual bits within a byte,\nas specified by the information in the blue box.\n\nThe user may enter in the blue box a byte name\n(such as ACC) or a byte address.\n\nIf the address is bit-addressable, then the bit\nfields are editable.", bitFieldInfoTitle, "bit field information");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.bitfieldPanel.add((Component)this.bitFieldInfoButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 11;
        gbc.gridwidth = 8;
        gbc.gridheight = 2;
        this.microcontroller.add((Component)this.bitfieldPanel, gbc);
        this.removeAllBreakpointsButton.setMaximumSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setMinimumSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setPreferredSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setFont(new Font("Monospaced", 1, 12));
        this.removeAllBreakpointsButton.setText("Remove All Breakpoints");
        this.removeAllBreakpointsButton.setMargin(new Insets(1, 1, 1, 1));
        this.removeAllBreakpointsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.removeAllBreakpointsButtonMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 24;
        gbc.gridwidth = 4;
        gbc.anchor = 14;
        this.microcontroller.add((Component)this.removeAllBreakpointsButton, gbc);
        this.copyright.setFont(new Font("Dialog", 0, 12));
        this.copyright.setText("Copyright \u00a92005-2021 James Rogers");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 24;
        gbc.gridwidth = 10;
        gbc.anchor = 16;
        this.microcontroller.add((Component)this.copyright, gbc);
        this.dph.setFont(new Font("Monospaced", 0, 12));
        this.dph.setHorizontalAlignment(4);
        this.dph.setText("0x00");
        this.dph.setMaximumSize(new Dimension(40, 19));
        this.dph.setMinimumSize(new Dimension(40, 19));
        this.dph.setPreferredSize(new Dimension(40, 19));
        this.dph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.dphActionPerformed(evt);
            }
        });
        this.dph.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.dphFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 8;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.dph, gbc);
        this.dphLabel.setText("DPH");
        this.dphLabel.setToolTipText("addr: " + Text.inHex(131));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 8;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.dphLabel, gbc);
        this.dpl.setFont(new Font("Monospaced", 0, 12));
        this.dpl.setHorizontalAlignment(4);
        this.dpl.setText("0x00");
        this.dpl.setMaximumSize(new Dimension(40, 19));
        this.dpl.setMinimumSize(new Dimension(40, 19));
        this.dpl.setPreferredSize(new Dimension(40, 19));
        this.dpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.dplActionPerformed(evt);
            }
        });
        this.dpl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.dplFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 9;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.dpl, gbc);
        this.dplLabel.setText("DPL");
        this.dplLabel.setToolTipText("addr: " + Text.inHex(130));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 9;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.dplLabel, gbc);
        this.b.setFont(new Font("Monospaced", 0, 12));
        this.b.setHorizontalAlignment(4);
        this.b.setText("0x00");
        this.b.setMaximumSize(new Dimension(40, 19));
        this.b.setMinimumSize(new Dimension(40, 19));
        this.b.setPreferredSize(new Dimension(40, 19));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.bActionPerformed(evt);
            }
        });
        this.b.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.bFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.b, gbc);
        this.bLabel.setText("B");
        this.bLabel.setToolTipText("addr: " + Text.inHex(240));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.bLabel, gbc);
        this.pcon.setFont(new Font("Monospaced", 0, 12));
        this.pcon.setHorizontalAlignment(4);
        this.pcon.setText("0x00");
        this.pcon.setMaximumSize(new Dimension(40, 19));
        this.pcon.setMinimumSize(new Dimension(40, 19));
        this.pcon.setPreferredSize(new Dimension(40, 19));
        this.pcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.pconActionPerformed(evt);
            }
        });
        this.pcon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.pconFocusLost(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 7;
        gbc.anchor = 17;
        this.microcontroller.add((Component)this.pcon, gbc);
        this.pconLabel.setText("PCON");
        this.pconLabel.setToolTipText("addr: " + Text.inHex(135));
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 7;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.pconLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 12;
        this.microcontroller.add((Component)this.updateFreqPanel, gbc);
        String logoPath = this.isDI ? "edsim51sh/fadedLogo_DI.png" : "edsim51sh/fadedLogo_SH.png";
        URL imageURL = this.getClass().getClassLoader().getResource(logoPath);
        if (imageURL != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 12;
            gbc.gridheight = 20;
            gbc.anchor = 10;
            this.microcontroller.add((Component)new JLabel(new ImageIcon(imageURL)), gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.microcontroller, gbc);
        this.assembly.setLayout(new GridBagLayout());
        this.assembly.setBackground(new Color(102, 153, 255));
        this.assembly.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.assembly.setMaximumSize(new Dimension(610, 480));
        this.assembly.setMinimumSize(new Dimension(610, 480));
        this.assembly.setPreferredSize(new Dimension(610, 480));
        this.messageUnlockZoomPanel.setLayout(new GridBagLayout());
        this.messageBox.setEditable(false);
        this.messageBox.setFont(new Font("Monospaced", 0, 12));
        this.messageBoxPanel.setMaximumSize(new Dimension(305, 40));
        this.messageBoxPanel.setMinimumSize(new Dimension(305, 40));
        this.messageBoxPanel.setPreferredSize(new Dimension(305, 40));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.messageBoxPanel.setViewportView(this.messageBox);
        this.messageBoxPanel.setHorizontalScrollBarPolicy(32);
        this.messageUnlockZoomPanel.add((Component)this.messageBoxPanel, gbc);
        this.unlockZoomPanel.setLayout(new GridBagLayout());
        this.unlockButton.setText("U");
        this.unlockButton.setToolTipText("Unlock the source code pane");
        this.unlockButton.setFont(new Font("Monospaced", 1, 12));
        this.unlockButton.setMargin(new Insets(1, 1, 1, 1));
        this.unlockButton.setMaximumSize(new Dimension(15, 15));
        this.unlockButton.setMinimumSize(new Dimension(15, 15));
        this.unlockButton.setPreferredSize(new Dimension(15, 15));
        this.unlockButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.openUnlockedAssemblyCodeBox();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.unlockZoomPanel.add((Component)this.unlockButton, gbc);
        if (this.settings.isSmall()) {
            this.zoomButton.setText("+");
            this.zoomButton.setToolTipText("Zoom in main window");
        } else {
            this.zoomButton.setText("-");
            this.zoomButton.setToolTipText("Zoom out main window");
        }
        this.zoomButton.setFont(new Font("Monospaced", 1, 12));
        this.zoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.zoomButton.setMaximumSize(new Dimension(15, 15));
        this.zoomButton.setMinimumSize(new Dimension(15, 15));
        this.zoomButton.setPreferredSize(new Dimension(15, 15));
        this.zoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.zoomWindowButtonPressed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.unlockZoomPanel.add((Component)this.zoomButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.messageUnlockZoomPanel.add((Component)this.unlockZoomPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.assembly.add((Component)this.messageUnlockZoomPanel, gbc);
        this.portPinConnectionsPanel.setLayout(new GridBagLayout());
        this.portPinConnectionsPanel.setBackground(new Color(0, 0, 0));
        this.portPinConnectionsPanel.setBorder(new LineBorder(new Color(255, 255, 255), 2));
        this.portPinConnectionsPanel.setMaximumSize(new Dimension(290, 480));
        this.portPinConnectionsPanel.setMinimumSize(new Dimension(290, 480));
        this.portPinConnectionsPanel.setPreferredSize(new Dimension(290, 480));
        this.port0DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port0DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port0DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port0DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port0DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(25, 0, 0, 0);
        gbc.anchor = 18;
        this.portPinConnectionsPanel.add((Component)this.port0DescZoomButton, gbc);
        this.port0DescZoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String[][] descs = MainPanel.this.ppDesc.getEntirePortDescriptionAndToolTip(0);
                if (MainPanel.this.port0Frame == null) {
                    MainPanel.this.port0Frame = new PortPinsDescFrame(MainPanel.this.isDI, 0, MainPanel.this.cpu.memory.port0, descs[0], descs[1]);
                    MainPanel.this.alwaysOnTopFrames.addElement(MainPanel.this.port0Frame);
                    MainPanel.this.alwaysOnTopCheckBoxes.addElement(MainPanel.this.port0Frame.getCheckBox());
                } else {
                    MainPanel.this.port0Frame.setVisible(true);
                }
            }
        });
        this.port1DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port1DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port1DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port1DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port1DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(25, 0, 0, 0);
        gbc.anchor = 18;
        this.portPinConnectionsPanel.add((Component)this.port1DescZoomButton, gbc);
        this.port1DescZoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String[][] descs = MainPanel.this.ppDesc.getEntirePortDescriptionAndToolTip(1);
                if (MainPanel.this.port1Frame == null) {
                    MainPanel.this.port1Frame = new PortPinsDescFrame(MainPanel.this.isDI, 1, MainPanel.this.cpu.memory.port1, descs[0], descs[1]);
                    MainPanel.this.alwaysOnTopFrames.addElement(MainPanel.this.port1Frame);
                    MainPanel.this.alwaysOnTopCheckBoxes.addElement(MainPanel.this.port1Frame.getCheckBox());
                } else {
                    MainPanel.this.port1Frame.setVisible(true);
                }
            }
        });
        this.port2DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port2DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port2DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port2DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port2DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(25, 0, 0, 0);
        gbc.anchor = 18;
        this.portPinConnectionsPanel.add((Component)this.port2DescZoomButton, gbc);
        this.port2DescZoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String[][] descs = MainPanel.this.ppDesc.getEntirePortDescriptionAndToolTip(2);
                if (MainPanel.this.port2Frame == null) {
                    MainPanel.this.port2Frame = new PortPinsDescFrame(MainPanel.this.isDI, 2, MainPanel.this.cpu.memory.port2, descs[0], descs[1]);
                    MainPanel.this.alwaysOnTopFrames.addElement(MainPanel.this.port2Frame);
                    MainPanel.this.alwaysOnTopCheckBoxes.addElement(MainPanel.this.port2Frame.getCheckBox());
                } else {
                    MainPanel.this.port2Frame.setVisible(true);
                }
            }
        });
        this.port3DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port3DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port3DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port3DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port3DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(25, 0, 0, 0);
        gbc.anchor = 18;
        this.portPinConnectionsPanel.add((Component)this.port3DescZoomButton, gbc);
        this.port3DescZoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String[][] descs = MainPanel.this.ppDesc.getEntirePortDescriptionAndToolTip(3);
                if (MainPanel.this.port3Frame == null) {
                    MainPanel.this.port3Frame = new PortPinsDescFrame(MainPanel.this.isDI, 3, MainPanel.this.cpu.memory.port3, descs[0], descs[1]);
                    MainPanel.this.alwaysOnTopFrames.addElement(MainPanel.this.port3Frame);
                    MainPanel.this.alwaysOnTopCheckBoxes.addElement(MainPanel.this.port3Frame.getCheckBox());
                } else {
                    MainPanel.this.port3Frame.setVisible(true);
                }
            }
        });
        this.port0Panel.setLayout(new GridBagLayout());
        this.port0Panel.setBackground(new Color(0, 0, 0));
        this.port0Panel.setMaximumSize(new Dimension(250, 120));
        this.port0Panel.setMinimumSize(new Dimension(250, 120));
        this.port0Panel.setPreferredSize(new Dimension(250, 120));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port0Panel, gbc);
        this.port1Panel.setLayout(new GridBagLayout());
        this.port1Panel.setBackground(new Color(0, 0, 0));
        this.port1Panel.setMaximumSize(new Dimension(214, 120));
        this.port1Panel.setMinimumSize(new Dimension(214, 120));
        this.port1Panel.setPreferredSize(new Dimension(214, 120));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port1Panel, gbc);
        this.port2Panel.setLayout(new GridBagLayout());
        this.port2Panel.setBackground(new Color(0, 0, 0));
        this.port2Panel.setMaximumSize(new Dimension(166, 120));
        this.port2Panel.setMinimumSize(new Dimension(166, 120));
        this.port2Panel.setPreferredSize(new Dimension(166, 120));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port2Panel, gbc);
        this.port3Panel.setLayout(new GridBagLayout());
        this.port3Panel.setBackground(new Color(0, 0, 0));
        this.port3Panel.setMaximumSize(new Dimension(250, 120));
        this.port3Panel.setMinimumSize(new Dimension(250, 120));
        this.port3Panel.setPreferredSize(new Dimension(250, 120));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port3Panel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.anchor = 11;
        this.assembly.add((Component)this.portPinConnectionsPanel, gbc);
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setBackground(new Color(102, 153, 255));
        this.controlPanel.setMaximumSize(new Dimension(320, 20));
        this.controlPanel.setMinimumSize(new Dimension(320, 20));
        this.controlPanel.setPreferredSize(new Dimension(320, 20));
        this.run.setFont(new Font("Monospaced", 1, 12));
        this.run.setText(" Run ");
        this.run.setToolTipText("Execute instruction at quarter second intervals.");
        this.run.setBorder(new BevelBorder(0));
        this.run.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.runMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.run, gbc);
        this.quit.setBackground(new Color(255, 102, 102));
        this.quit.setFont(new Font("Monospaced", 1, 12));
        this.quit.setText("");
        this.quit.setToolTipText("Close simulator.");
        this.quit.setBorder(new BevelBorder(0));
        this.quit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.quitMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.quit, gbc);
        this.copy.setFont(new Font("Monospaced", 1, 12));
        this.copy.setText("Copy");
        this.copy.setToolTipText("Copy assembly code to clipboard.");
        this.copy.setBorder(new BevelBorder(0));
        this.copy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.copyMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.copy, gbc);
        this.paste.setFont(new Font("Monospaced", 1, 12));
        this.paste.setText("Paste");
        this.paste.setToolTipText("Paste text from clipboard into assembly code box below.");
        this.paste.setBorder(new BevelBorder(0));
        this.paste.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.pasteMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.paste, gbc);
        this.newFile.setBackground(new Color(153, 153, 255));
        this.newFile.setFont(new Font("Monospaced", 1, 12));
        this.newFile.setText("New");
        this.newFile.setToolTipText("Create a new file.");
        this.newFile.setBorder(new BevelBorder(0));
        this.newFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.newFileMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.newFile, gbc);
        this.fileOpen.setBackground(new Color(153, 153, 255));
        this.fileOpen.setFont(new Font("Monospaced", 1, 12));
        this.fileOpen.setText("Load");
        this.fileOpen.setToolTipText("Load an assembly source file.");
        this.fileOpen.setBorder(new BevelBorder(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.fileOpen, gbc);
        this.reset.setFont(new Font("Monospaced", 1, 12));
        this.reset.setText("RST");
        this.reset.setToolTipText("Reset 8051 and external hardware.");
        this.reset.setBorder(new BevelBorder(0));
        this.reset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.resetMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.reset, gbc);
        this.step.setFont(new Font("Monospaced", 1, 12));
        this.step.setText("Assm");
        this.step.setToolTipText("Assemble source code.");
        this.step.setBorder(new BevelBorder(0));
        this.step.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainPanel.this.stepMouseClicked(evt);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.step, gbc);
        this.fileSave.setBackground(new Color(153, 153, 255));
        this.fileSave.setFont(new Font("Monospaced", 1, 12));
        this.fileSave.setText("Save");
        this.fileSave.setToolTipText("Save assembly source file.");
        this.fileSave.setBorder(new BevelBorder(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        this.controlPanel.add((Component)this.fileSave, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        this.assembly.add((Component)this.controlPanel, gbc);
        this.assemblyCodeBoxPanel.setMaximumSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setMinimumSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setPreferredSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setWheelScrollingEnabled(true);
        this.assemblyCodeBoxPanel.setViewportView(this.assemblyCodeBox);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.sysClockField.setHorizontalAlignment(0);
        this.microcontroller.add((Component)this.sysClockField, gbc);
        this.sysClockField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.readSysClockField();
            }
        });
        this.sysClockField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainPanel.this.readSysClockField();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.assembly.add((Component)this.assemblyCodeBoxPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.assembly, gbc);
        this.targetBoardPanel.add(this.targetBoardScrollPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        this.add((Component)this.targetBoardPanel, gbc);
    }

    private void readSysClockField() {
        try {
            double d = Double.parseDouble(this.sysClockField.getText());
            if (d >= 0.001 && d <= 999.0) {
                this.settings.setSystemFreq(d);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.sysClockField.setText(String.valueOf(this.settings.getSystemFreq()));
        if (this.cpu.setMachineCycleLength(12.0 / this.settings.getSystemFreq())) {
            this.resetMouseClicked();
        }
    }

    private void removeAllBreakpointsButtonMouseClicked(MouseEvent evt) {
        if (this.breakpoints == null || this.breakpoints.size() == 0) {
            return;
        }
        String assembly = this.assemblyCodeBox.getText();
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            int address = (Integer)this.breakpoints.elementAt(i);
            String s = Text.inHex(address, false, 4);
            assembly = assembly.replace(s + "*", s + "|");
        }
        this.breakpoints = null;
        this.assemblyCodeBox.setText(assembly);
        this.removeAllBreakpointsButton.setEnabled(false);
        if (!this.cpu.running) {
            this.assemblyCodeBox.highlightAddress(this.cpu.getPc());
        }
    }

    private void updatePcViaUser() {
        int pcValue = Text.parseNumericData(this.pc.getText());
        this.cpu.setPc(pcValue);
        this.pc.setText(Text.inHex(this.cpu.getPc(), true, 4));
        this.assemblyCodeBox.highlightAddress(this.cpu.getPc());
    }

    private void pcActionPerformed(ActionEvent evt) {
        this.updatePcViaUser();
    }

    public void pcFocusLost(FocusEvent evt) {
        this.updatePcViaUser();
    }

    private void bFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.b, 240, true);
    }

    private void pconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.pcon, 135, true);
    }

    private void pconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.pcon, 135, true);
    }

    private void bActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.b, 240, true);
    }

    private void dplFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.dpl, 130, true);
    }

    private void dplActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.dpl, 130, true);
    }

    private void dphFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.dph, 131, true);
    }

    private void dphActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.dph, 131, true);
    }

    private void ieFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.ie, 168, true);
    }

    private void ieActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.ie, 168, true);
    }

    private void stepMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.setEditable(false);
        this.messageBox.setBackground(Color.LIGHT_GRAY);
        this.step();
    }

    private void bit0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(0);
    }

    private void bit0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(0);
    }

    private void bit1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(1);
    }

    private void bit1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(1);
    }

    private void bit2FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(2);
    }

    private void bit2ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(2);
    }

    private void bit3FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(3);
    }

    private void bit3ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(3);
    }

    private void bit4FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(4);
    }

    private void bit4ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(4);
    }

    private void bit5FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(5);
    }

    private void bit5ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(5);
    }

    private void bit6FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(6);
    }

    private void bit6ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(6);
    }

    private void bit7FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(7);
    }

    private void bit7ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(7);
    }

    private void bitfieldByteAddressFocusLost(FocusEvent evt) {
        this.updateBitFieldData();
    }

    private void bitfieldByteAddressActionPerformed(ActionEvent evt) {
        this.updateBitFieldData();
    }

    private void ipFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.ip, 184, true);
    }

    private void ipActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.ip, 184, true);
    }

    private void spFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.sp, 129, true);
    }

    private void spActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.sp, 129, true);
    }

    private void pswFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.psw, 208, true);
    }

    private void pswActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.psw, 208, true);
    }

    private void memoryTypeButtonMouseClicked(MouseEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.settings.setDataMemoryDisplayed(false);
            this.memoryTypeButton.setText("Code Memory");
            this.addrLabel.setText("Modify Code");
            this.memoryWindowAddressField.setText(Text.inHex(this.settings.getCodeWindowStartAddress(), true, 4));
            this.updateCodeByteField();
        } else {
            this.settings.setDataMemoryDisplayed(true);
            this.memoryTypeButton.setText("Data Memory");
            this.addrLabel.setText("Modify RAM");
            this.memoryWindowAddressField.setText("0x00");
            this.updateRamByteField();
        }
        this.updateMemoryWindow();
    }

    private void sconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.scon, 152, true);
    }

    private void sconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.scon, 152, true);
    }

    private void sbufFocusLost(FocusEvent evt) {
        this.updateSbufFromField();
    }

    private void sbufActionPerformed(ActionEvent evt) {
        this.updateSbufFromField();
    }

    private void tconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tcon, 136, true);
    }

    private void tconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tcon, 136, true);
    }

    private void tmodFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tmod, 137, true);
    }

    private void tmodActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tmod, 137, true);
    }

    private void tl1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tl1, 139, true);
    }

    private void tl1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tl1, 139, true);
    }

    private void th1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.th1, 141, true);
    }

    private void th1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.th1, 141, true);
    }

    private void tl0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tl0, 138, true);
    }

    private void tl0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tl0, 138, true);
    }

    private void th0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.th0, 140, true);
    }

    private void th0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.th0, 140, true);
    }

    private void memoryWindowByteFieldActionPerformed(ActionEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByte();
        } else {
            this.updateCodeByte();
        }
    }

    private void memoryWindowByteFieldFocusLost(FocusEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByte();
        } else {
            this.updateCodeByte();
        }
    }

    private void memoryWindowAddressFieldFocusLost(FocusEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByteField();
        } else {
            this.updateCodeByteField();
        }
    }

    private void memoryWindowAddressFieldActionPerformed(ActionEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByteField();
        } else {
            this.updateCodeByteField();
        }
    }

    private void updateRamByte() {
        int data = Text.parseNumericData(this.memoryWindowByteField.getText());
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        try {
            this.cpu.memory.writeByte(address, data);
            this.updateGui();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateRamByteField();
    }

    private void updateCodeByte() {
        int data = Text.parseNumericData(this.memoryWindowByteField.getText());
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        try {
            this.cpu.memory.codeMemory[address].setCode(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateCodeByteField();
    }

    private void updateRamByteField() {
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        if (address < 0 || address > 128) {
            address = 0;
        }
        try {
            this.memoryWindowByteField.setText(Text.inHex(this.cpu.memory.readByte(address)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memoryWindowAddressField.setText(Text.inHex(address));
    }

    private void updateCodeByteField() {
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        if (address < 0 || address > 65536) {
            address = 0;
        }
        try {
            int code = this.cpu.memory.codeMemory[address].getCode();
            this.memoryWindowByteField.setText(Text.inHex(code));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memoryWindowAddressField.setText(Text.inHex(address, true, 4));
        this.settings.setCodeWindowStartAddress(address);
        this.updateMemoryWindow();
    }

    private void updateMemoryWindow() {
        this.memoryWindow.update(this.cpu.memory.getMemoryWindow(this.settings.isDataMemoryDisplayed(), this.settings.getCodeWindowStartAddress()), this.settings.isDataMemoryDisplayed());
    }

    private int getBitFieldByteAddress() {
        String location = this.bitfieldByteAddress.getText().trim().toUpperCase();
        int address = Assembler.getSfrAddress(location);
        if (address == -1 && location.length() == 2) {
            int registerNumber = location.charAt(1) - 48;
            if (location.charAt(0) == 'R' && registerNumber >= 0 && registerNumber <= 7) {
                try {
                    address = this.cpu.memory.getRegisterAddress(registerNumber);
                }
                catch (Exception exception) {}
            } else {
                address = -1;
            }
        }
        if (address == -1 && (address = Text.parseNumericData(location)) == 0x1000000) {
            address = 224;
        }
        return address;
    }

    private void updateBitFieldData() {
        int address = this.getBitFieldByteAddress();
        this.bitfieldByteAddress.setToolTipText("addr: " + Text.inHex(address));
        String location = Assembler.getSfrName(address);
        if (location.equals("")) {
            location = this.cpu.memory.getRegisterName(address);
        }
        if (location == null) {
            location = Text.inHex(address);
        }
        this.bitfieldByteAddress.setText(location);
        this.settings.setBitfieldByteAddressString(location);
        try {
            int data = address == 128 || address == 144 || address == 160 || address == 176 ? this.cpu.memory.readPortLatches(address) : (address == 153 ? this.cpu.memory.readSbufWriteOnly() : this.cpu.memory.readByte(address));
            Memory cfr_ignored_0 = this.cpu.memory;
            boolean isBitAddressable = Memory.isBitAddressable(address);
            boolean editable = this.fieldsEnabled && isBitAddressable;
            for (int i = 0; i < 8; ++i) {
                JTextField bitTextField = this.getBitTextField(i);
                bitTextField.setText(String.valueOf(data >> i & 1));
                bitTextField.setEditable(editable);
                String bitAddressName = isBitAddressable ? Assembler.getSbitName(address + i) : this.getNonBitAddressableSbitName(location, i);
                if (bitAddressName.equals("")) {
                    bitTextField.setToolTipText(String.valueOf(i));
                    continue;
                }
                bitTextField.setToolTipText(bitAddressName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNonBitAddressableSbitName(String sfrName, int bitNumber) {
        if (sfrName.equals("PCON")) {
            return this.getPconBitName(bitNumber);
        }
        if (sfrName.equals("TMOD")) {
            return this.getTmodBitName(bitNumber);
        }
        return "";
    }

    private String getPconBitName(int bitNumber) {
        if (bitNumber == 7) {
            return "SMOD";
        }
        return "";
    }

    private String getTmodBitName(int bitNumber) {
        switch (bitNumber) {
            case 7: {
                return "T1: G";
            }
            case 6: {
                return "T1: C/T";
            }
            case 5: {
                return "T1: M1";
            }
            case 4: {
                return "T1: M0";
            }
            case 3: {
                return "T0: G";
            }
            case 2: {
                return "T0: C/T";
            }
            case 1: {
                return "T0: M1";
            }
            case 0: {
                return "T0: M0";
            }
        }
        return "";
    }

    private void updateDataMemoryViaBitField(int bitNumber) {
        JTextField bitTextField = this.getBitTextField(bitNumber);
        int byteAddress = this.getBitFieldByteAddress();
        try {
            if (bitTextField.getText().trim().equals("1")) {
                this.cpu.memory.setBit(byteAddress, bitNumber);
            }
            if (bitTextField.getText().trim().equals("0")) {
                this.cpu.memory.clearBit(byteAddress, bitNumber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byteAddress == 208) {
            this.setRegistersToolTipText();
        }
        this.cpu.memory.updatePortPins();
        this.updateGui();
    }

    private JTextField getBitTextField(int bitNumber) {
        switch (bitNumber) {
            case 0: {
                return this.bit0;
            }
            case 1: {
                return this.bit1;
            }
            case 2: {
                return this.bit2;
            }
            case 3: {
                return this.bit3;
            }
            case 4: {
                return this.bit4;
            }
            case 5: {
                return this.bit5;
            }
            case 6: {
                return this.bit6;
            }
        }
        return this.bit7;
    }

    private void copyMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.copyTextToClipboard();
    }

    private void pasteMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.pasteTextFromClipboard();
    }

    private void quitMouseClicked(MouseEvent evt) {
        block10: {
            block7: {
                block9: {
                    block8: {
                        this.revokeAlwaysOnTop();
                        if (this.isCodeSaved()) break block7;
                        CodeNotSaved cns = new CodeNotSaved(this, "Source code not saved.\nSave file before exiting?", false);
                        int response = cns.showConfirmDialog();
                        if (response == 1) break block8;
                        if (response != 0) break block9;
                    }
                    this.srw.writeSettings();
                    if (this.targetBoard != null) {
                        this.targetBoard.saveHardwareSettings();
                    }
                    System.exit(0);
                }
                if (this.unlockedAssemblyCodeFrame != null) {
                    this.unlockedAssemblyCodeFrame.refocus();
                } else {
                    this.setAssemblyCodeBoxFocus();
                }
                break block10;
            }
            this.srw.writeSettings();
            if (this.targetBoard != null) {
                this.targetBoard.saveHardwareSettings();
            }
            System.exit(0);
        }
    }

    private void port0FocusLost(FocusEvent evt) {
        this.updatePortFromField(0);
    }

    private void port0ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(0);
    }

    private void port2FocusLost(FocusEvent evt) {
        this.updatePortFromField(2);
    }

    private void port2ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(2);
    }

    private void port3FocusLost(FocusEvent evt) {
        this.updatePortFromField(3);
    }

    private void port3ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(3);
    }

    private void port1FocusLost(FocusEvent evt) {
        this.updatePortFromField(1);
    }

    private void port1ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(1);
    }

    private void updateSbufFromField() {
        int data = Text.parseNumericData(this.sbuf.getText());
        if (data != 0x1000000) {
            try {
                this.cpu.memory.writeByte(153, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sbuf.setText(Text.inHex(this.cpu.memory.readSbufWriteOnly()));
    }

    private void updatePortFromField(int portNumber) {
        int address;
        Port port;
        JTextField pins;
        JTextField latches;
        if (portNumber < 0 || portNumber > 3) {
            return;
        }
        if (portNumber == 0) {
            latches = this.port0;
            pins = this.port0pins;
            port = this.cpu.memory.port0;
            address = 128;
        } else if (portNumber == 1) {
            latches = this.port1;
            pins = this.port1pins;
            port = this.cpu.memory.port1;
            address = 144;
        } else if (portNumber == 2) {
            latches = this.port2;
            pins = this.port2pins;
            port = this.cpu.memory.port2;
            address = 160;
        } else {
            latches = this.port3;
            pins = this.port3pins;
            port = this.cpu.memory.port3;
            address = 176;
        }
        try {
            port.writePort(latches.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            latches.setText(Text.inHex(this.cpu.memory.readPortLatches(address)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTextField(pins, port.getPortPins(), true);
        this.updatePortPinFields();
        this.updateBitFieldData();
        this.targetBoard.updatePortPins();
    }

    private void register0FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register0, 0);
    }

    private void register1FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register1, 1);
    }

    private void register2FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register2, 2);
    }

    private void register3FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register3, 3);
    }

    private void register4FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register4, 4);
    }

    private void register5FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register5, 5);
    }

    private void register6FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register6, 6);
    }

    private void register7FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register7, 7);
    }

    private void runMouseClicked(MouseEvent evt) {
        if (this.cpu.running) {
            this.enableButtons(true);
            this.enableAllControllerPanelFields(true);
            this.assemblyCodeBox.highlightAddress(this.cpu.getPc());
            this.cpu.running = false;
            this.run.setText(" Run ");
        } else {
            this.enableButtons(false);
            this.assemblyCodeBox.setEditable(false);
            this.enableAllControllerPanelFields(false);
            this.cpu.running = true;
            this.run.setText("Pause");
            this.start();
        }
    }

    private void enableButtons(boolean b) {
        this.reset.setEnabled(b);
        this.step.setEnabled(b);
        this.fileOpen.setEnabled(b);
        this.fileSave.setEnabled(b);
        this.copy.setEnabled(b);
        this.paste.setEnabled(b);
        this.sysClockField.setEnabled(b);
    }

    public void resetMouseClicked() {
        this.enableButtons(true);
        this.enableAllControllerPanelFields(true);
        this.assemblyCodeBox.highlightAddress(this.cpu.getPc());
        this.run.setText(" Run ");
        this.step.setText("Assm");
        this.step.setToolTipText("Assemble source code.");
        this.cpu.running = false;
        this.assembler = null;
        this.cpu.reset();
        this.messageBox.setBackground(Color.LIGHT_GRAY);
        this.messageBox.setText("Reset: PC = 0x0000");
        this.pc.setText("0x0000");
        this.updateGui();
        if (!this.assemblyCodeBox.isEditable()) {
            this.assemblyCodeBox.setEditable(true);
            this.assemblyCodeBox.setTextWithoutModification(this.preAssembledCode);
            if (!this.assemblyCodeBox.hasFocus()) {
                this.assemblyCodeBox.requestFocusInWindow();
            }
            this.assemblyCodeBox.setCaretPosition(0);
        }
        this.targetBoard.reset();
    }

    private void resetMouseClicked(MouseEvent evt) {
        this.resetMouseClicked();
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new WorkerThread(this.assemblyCodeBox.getText());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void runAssemblyCode(String assemblyCode) {
        while (this.cpu.running) {
            long sleepTime;
            long batchStartTime = System.currentTimeMillis();
            try {
                boolean isBreakpoint = this.step(this.settings.getInstructionBatchSize(), false, assemblyCode);
                if (isBreakpoint) {
                    this.cpu.running = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainPanel.this.step.setEnabled(true);
                            MainPanel.this.reset.setEnabled(true);
                            MainPanel.this.enableAllControllerPanelFields(true);
                            MainPanel.this.assemblyCodeBox.highlightAddress(MainPanel.this.cpu.getPc());
                            MainPanel.this.run.setText(" Run ");
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((sleepTime = 200L - (System.currentTimeMillis() - batchStartTime)) <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.memoryWindow.enableColorChanger(true);
        this.thread = null;
    }

    private void step() {
        this.step(1, true, this.assemblyCodeBox.getText());
    }

    private boolean step(int instructionBatchSize, final boolean showExecutedInstruction, String assemblyCode) {
        boolean isBreakpoint = false;
        if (this.assembler == null) {
            this.messageBox.setText("Assembling ... please wait");
            this.assembler = new Assembler(this, assemblyCode);
        }
        if (!this.cpu.codeLoaded) {
            try {
                this.preAssembledCode = assemblyCode;
                this.cpu.loadCode(this.assembler.assemble());
                this.assembler.codeWithPc = this.showAllBreakpoints(this.assembler.codeWithPc);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainPanel.this.pc.setText("0x0000");
                        MainPanel.this.assemblyCodeBox.setTextWithoutModification(((MainPanel)MainPanel.this).assembler.codeWithPc);
                        MainPanel.this.assemblyCodeBox.highlightAddress(0);
                        if (!MainPanel.this.settings.isDataMemoryDisplayed()) {
                            MainPanel.this.updateMemoryWindow();
                            MainPanel.this.updateCodeByteField();
                        }
                        MainPanel.this.messageBox.setBackground(Color.LIGHT_GRAY);
                        MainPanel.this.messageBox.setText("No errors");
                        MainPanel.this.step.setText("Step");
                        MainPanel.this.step.setToolTipText("Execute next instruction.");
                    }
                });
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            return false;
        }
        try {
            final ExecutedInstructionInfo info = this.cpu.executeInstructions(instructionBatchSize, this.breakpoints, this.showMovxWarning);
            isBreakpoint = info.isBreakpoint || info.isMovx;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MainPanel.this.showMovxWarning && info.isMovx) {
                        int option = JOptionPane.showConfirmDialog(null, "MOVX instruction executed.\nSince the simulator has no external memory,\nMOVX instructions are not implemented,\nexcept for the PC being incremented.\n\nShow this warning every time a\nMOVX instruction is executed?", "Warning! MOVX instruction executed.", 0, 2);
                        MainPanel.this.showMovxWarning = option == 0;
                    }
                    MainPanel.this.messageBox.setBackground(Color.LIGHT_GRAY);
                    String elapsedTime = "Time: " + MainPanel.this.cpu.getProgramElapsedTimeString() + " - Instructions: " + MainPanel.this.cpu.getNumberOfExecutedInstructions();
                    if (showExecutedInstruction) {
                        MainPanel.this.messageBox.setText("Executed " + Text.inHex(info.pc, true, 4) + ": " + info.mneumonic + " | " + elapsedTime);
                    } else {
                        MainPanel.this.messageBox.setText(elapsedTime);
                    }
                    if (!MainPanel.this.cpu.running) {
                        MainPanel.this.assemblyCodeBox.highlightAddress(MainPanel.this.cpu.getPc());
                    }
                    MainPanel.this.pc.setText(Text.inHex(MainPanel.this.cpu.getPc(), true, 4));
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainPanel.this.updateGui();
            }
        });
        return isBreakpoint;
    }

    private void handleException(Exception ex) {
        this.resetMouseClicked();
        String nonEdSimErrorMessage = this.version + "\n\n" + ex.toString() + "\n\n" + Text.getErrorStackTrace(ex);
        try {
            this.assemblyCodeBox.setAssemblerError((Edsim51Exception)ex);
            this.messageBox.setBackground(Color.RED);
            this.messageBox.setText(Text.lessJavaErrorMessage(ex.toString()));
        }
        catch (Exception ex1) {
            if (!(ex1 instanceof ClassCastException)) {
                nonEdSimErrorMessage = this.version + "\n\nHandling of the following exception:\n" + ex.toString() + "\n\n" + Text.getErrorStackTrace(ex) + "\n\nresulted in the following exception:\n" + ex1.toString() + "\n\n" + Text.getErrorStackTrace(ex1);
            }
            this.messageBox.setText("");
            if (this.bugFrame == null) {
                this.bugFrame = new BugFrame(nonEdSimErrorMessage, this.clipboard);
            } else {
                this.bugFrame.setBugDetails(nonEdSimErrorMessage);
            }
            this.bugFrame.setVisible(true);
        }
    }

    private void accFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.acc, 224, true);
    }

    private void accActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.acc, 224, true);
    }

    private void register0ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register0, 0);
    }

    private void register1ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register1, 1);
    }

    private void register2ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register2, 2);
    }

    private void register3ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register3, 3);
    }

    private void register4ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register4, 4);
    }

    private void register5ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register5, 5);
    }

    private void register6ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register6, 6);
    }

    private void register7ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register7, 7);
    }

    private void updateRegisterViaTextField(JTextField field, int registerNumber) {
        int data = Text.parseNumericData(field.getText());
        try {
            this.cpu.memory.writeRegister(registerNumber, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            field.setText(Text.inHex(this.cpu.memory.readRegister(registerNumber)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateMemoryWindow();
        this.updateBitFieldData();
    }

    private void updateDataMemoryViaTextField(JTextField field, int address, boolean isByteAddress) {
        int data = Text.parseNumericData(field.getText());
        if (isByteAddress) {
            try {
                this.cpu.memory.writeByte(address, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (address == 224) {
                this.updateTextFieldViaDataMemory(this.psw, 208, true);
            } else if (address == 208) {
                this.setRegistersToolTipText();
            }
        } else {
            try {
                if (data == 1) {
                    this.cpu.memory.setBit(address);
                } else if (data == 0) {
                    this.cpu.memory.clearBit(address);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateTextFieldViaDataMemory(field, address, isByteAddress);
        this.updateBitFieldData();
    }

    private void updateTextFieldViaDataMemory(JTextField field, int address, boolean isByteAddress) {
        try {
            int i = isByteAddress ? this.cpu.memory.readByte(address) : this.cpu.memory.getBit(address);
            this.updateTextField(field, i, isByteAddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateTextField(JTextField field, int data, boolean isByteAddress) {
        try {
            if (isByteAddress) {
                field.setText(Text.inHex(data));
            } else if (data == 0) {
                field.setText("0");
            } else if (data == 1) {
                field.setText("1");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateGui() {
        int registerAddressOffset = this.cpu.memory.getRegiserBankNumber() * 8;
        this.updateTextFieldViaDataMemory(this.register0, registerAddressOffset + 0, true);
        this.updateTextFieldViaDataMemory(this.register1, registerAddressOffset + 1, true);
        this.updateTextFieldViaDataMemory(this.register2, registerAddressOffset + 2, true);
        this.updateTextFieldViaDataMemory(this.register3, registerAddressOffset + 3, true);
        this.updateTextFieldViaDataMemory(this.register4, registerAddressOffset + 4, true);
        this.updateTextFieldViaDataMemory(this.register5, registerAddressOffset + 5, true);
        this.updateTextFieldViaDataMemory(this.register6, registerAddressOffset + 6, true);
        this.updateTextFieldViaDataMemory(this.register7, registerAddressOffset + 7, true);
        this.updateTextFieldViaDataMemory(this.acc, 224, true);
        this.updateTextFieldViaDataMemory(this.psw, 208, true);
        this.updateTextFieldViaDataMemory(this.sp, 129, true);
        this.updateTextFieldViaDataMemory(this.ip, 184, true);
        this.updateTextFieldViaDataMemory(this.ie, 168, true);
        this.updateTextFieldViaDataMemory(this.dph, 131, true);
        this.updateTextFieldViaDataMemory(this.dpl, 130, true);
        this.updateTextFieldViaDataMemory(this.b, 240, true);
        this.updateTextFieldViaDataMemory(this.pcon, 135, true);
        this.updateTextFieldViaDataMemory(this.tmod, 137, true);
        this.updateTextFieldViaDataMemory(this.tcon, 136, true);
        this.updateTextFieldViaDataMemory(this.th0, 140, true);
        this.updateTextFieldViaDataMemory(this.tl0, 138, true);
        this.updateTextFieldViaDataMemory(this.th1, 141, true);
        this.updateTextFieldViaDataMemory(this.tl1, 139, true);
        this.updateTextFieldViaDataMemory(this.scon, 152, true);
        this.updateTextFieldViaDataMemory(this.txd, 177, false);
        this.updateTextFieldViaDataMemory(this.rxd, 176, false);
        try {
            this.sbufReadOnly.setText(Text.inHex(this.cpu.memory.serial.getSbufReadOnly()));
            this.sbuf.setText(Text.inHex(this.cpu.memory.readSbufWriteOnly()));
            this.port0.setText(Text.inHex(this.cpu.memory.readPortLatches(128)));
            this.port0pins.setText(Text.inHex(this.cpu.memory.port0.getPortPins()));
            this.port1.setText(Text.inHex(this.cpu.memory.readPortLatches(144)));
            this.port1pins.setText(Text.inHex(this.cpu.memory.port1.getPortPins()));
            this.port2.setText(Text.inHex(this.cpu.memory.readPortLatches(160)));
            this.port2pins.setText(Text.inHex(this.cpu.memory.port2.getPortPins()));
            this.port3.setText(Text.inHex(this.cpu.memory.readPortLatches(176)));
            this.port3pins.setText(Text.inHex(this.cpu.memory.port3.getPortPins()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePortPinFields();
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateMemoryWindow();
        }
        this.updateBitFieldData();
        TargetBoard board = this.cpu.memory.getTargetBoard();
        if (board != null) {
            board.updateTargetBoardGraphics();
        }
    }

    private void enableAllControllerPanelFields(boolean aFlag) {
        this.register0.setEditable(aFlag);
        this.register1.setEditable(aFlag);
        this.register2.setEditable(aFlag);
        this.register3.setEditable(aFlag);
        this.register4.setEditable(aFlag);
        this.register5.setEditable(aFlag);
        this.register6.setEditable(aFlag);
        this.register7.setEditable(aFlag);
        this.acc.setEditable(aFlag);
        this.psw.setEditable(aFlag);
        this.sp.setEditable(aFlag);
        this.ip.setEditable(aFlag);
        this.ie.setEditable(aFlag);
        this.dph.setEditable(aFlag);
        this.dpl.setEditable(aFlag);
        this.b.setEditable(aFlag);
        this.pcon.setEditable(aFlag);
        this.tmod.setEditable(aFlag);
        this.tcon.setEditable(aFlag);
        this.th0.setEditable(aFlag);
        this.tl0.setEditable(aFlag);
        this.th1.setEditable(aFlag);
        this.tl1.setEditable(aFlag);
        this.port0.setEditable(aFlag);
        this.port1.setEditable(aFlag);
        this.port2.setEditable(aFlag);
        this.port3.setEditable(aFlag);
        this.scon.setEditable(aFlag);
        this.sbuf.setEditable(aFlag);
        this.memoryWindowAddressField.setEditable(aFlag);
        this.memoryWindowByteField.setEditable(aFlag);
        this.bitfieldByteAddress.setEditable(aFlag);
        int address = this.getBitFieldByteAddress();
        if (!aFlag || Memory.isBitAddressable(address)) {
            for (int i = 0; i < 8; ++i) {
                JTextField field = this.getBitTextField(i);
                field.setEditable(aFlag);
            }
        }
        this.pc.setEditable(aFlag);
        this.fieldsEnabled = aFlag;
    }

    private void updatePortPinFields() {
        for (int i = 0; i < 8; ++i) {
            this.ppDesc.setPortPinValue(0, i, this.cpu.memory.port0.getPortPin(i));
            this.ppDesc.setPortPinValue(1, i, this.cpu.memory.port1.getPortPin(i));
            this.ppDesc.setPortPinValue(2, i, this.cpu.memory.port2.getPortPin(i));
            this.ppDesc.setPortPinValue(3, i, this.cpu.memory.port3.getPortPin(i));
        }
        if (this.port0Frame != null) {
            this.port0Frame.setPinsStates();
        }
        if (this.port1Frame != null) {
            this.port1Frame.setPinsStates();
        }
        if (this.port2Frame != null) {
            this.port2Frame.setPinsStates();
        }
        if (this.port3Frame != null) {
            this.port3Frame.setPinsStates();
        }
    }

    private String showAllBreakpoints(String assembly) {
        if (this.breakpoints == null) {
            return assembly;
        }
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            String breakAddress = Text.inHex((Integer)this.breakpoints.elementAt(i), false, 4);
            if (assembly.indexOf(breakAddress + "|") == -1) {
                this.breakpoints.removeElementAt(i);
                --i;
                continue;
            }
            assembly = assembly.replace(breakAddress + "|", breakAddress + "*");
        }
        return assembly;
    }

    void setBreakpoint(String s) {
        int codeAddress;
        if (this.breakpoints == null) {
            this.breakpoints = new Vector();
        }
        if ((codeAddress = Text.parseNumericData(s + "H")) != 0x1000000) {
            String assembly = this.assemblyCodeBox.getText();
            for (int i = 0; i < this.breakpoints.size(); ++i) {
                if ((Integer)this.breakpoints.elementAt(i) != codeAddress) continue;
                this.breakpoints.removeElementAt(i);
                if (this.breakpoints.size() == 0) {
                    this.removeAllBreakpointsButton.setEnabled(false);
                }
                assembly = assembly.replace(s + "*", s + "|");
                this.assemblyCodeBox.setText(assembly);
                this.assemblyCodeBox.highlightAddress(this.cpu.getPc());
                return;
            }
            this.breakpoints.addElement(new Integer(codeAddress));
            this.removeAllBreakpointsButton.setEnabled(true);
            assembly = assembly.replace(s + "|", s + "*");
            this.assemblyCodeBox.setText(assembly);
            this.assemblyCodeBox.highlightAddress(codeAddress);
        }
    }

    void revokeAlwaysOnTop() {
        int i;
        if (this.unlockedAssemblyCodeFrame != null) {
            this.unlockedAssemblyCodeFrame.setVisible(false);
        }
        for (i = 0; i < this.alwaysOnTopFrames.size(); ++i) {
            ((JFrame)this.alwaysOnTopFrames.elementAt(i)).setAlwaysOnTop(false);
        }
        for (i = 0; i < this.alwaysOnTopFrames.size(); ++i) {
            ((JCheckBox)this.alwaysOnTopCheckBoxes.elementAt(i)).setSelected(false);
        }
    }

    void loadFileToAssemblyCodeBox() {
        this.resetMouseClicked();
        this.breakpoints = null;
        this.removeAllBreakpointsButton.setEnabled(false);
        this.messageBox.setText("Loading ... please wait");
        FileHandler handler = new FileHandler(this);
        FileHandler.ReturnedData rd = handler.readFile();
        if (rd != null) {
            if (rd.success) {
                this.assemblyCodeBox.setText(rd.fileContents);
                if (!this.assemblyCodeBox.hasFocus()) {
                    this.assemblyCodeBox.requestFocusInWindow();
                }
                this.assemblyCodeBox.setCaretPosition(0);
                this.messageBox.setText("");
                this.codeSaved = true;
            } else {
                this.messageBox.setText(Text.lessJavaErrorMessage(rd.message));
                this.highlightHexFileReadError(rd.fileContents, rd.errorLine);
            }
        } else {
            this.messageBox.setText("");
        }
        if (this.unlockedAssemblyCodeFrame != null) {
            this.unlockedAssemblyCodeFrame.refocus();
        }
    }

    private void highlightHexFileReadError(String fileContents, String errorLine) {
        if (fileContents == null || errorLine == null || fileContents.equals("") || errorLine.equals("")) {
            return;
        }
        this.assemblyCodeBox.setText(fileContents);
        int start = fileContents.indexOf(errorLine);
        if (start == -1) {
            return;
        }
        if (!this.assemblyCodeBox.hasFocus()) {
            this.assemblyCodeBox.requestFocusInWindow();
        }
        this.assemblyCodeBox.select(start, start + errorLine.length() + 1);
        this.assemblyCodeBox.setSelectionColor(Color.RED);
    }

    private void saveFile() {
        FileHandler handler = new FileHandler(this);
        this.resetMouseClicked();
        this.messageBox.setText("Saving ... please wait");
        FileHandler.ReturnedData rd = handler.saveFile(this.assemblyCodeBox.getText());
        this.messageBox.setText(Text.lessJavaErrorMessage(rd.message));
        this.codeSaved = rd.success;
        if (this.unlockedAssemblyCodeFrame != null) {
            this.unlockedAssemblyCodeFrame.refocus();
        }
    }

    private class FileAction
    implements ActionListener {
        int returnValue;
        MainPanel sim;

        FileAction(MainPanel sim) {
            this.sim = sim;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sim.revokeAlwaysOnTop();
            MainPanel.this.messageBox.setBackground(Color.LIGHT_GRAY);
            if (e.getSource() == MainPanel.this.fileOpen) {
                if (!MainPanel.this.isCodeSaved()) {
                    CodeNotSaved cns = new CodeNotSaved(this.sim, "Existing source code not saved.\nSave file before loading another?", true);
                    cns.showConfirmDialog();
                    if (MainPanel.this.unlockedAssemblyCodeFrame != null) {
                        MainPanel.this.unlockedAssemblyCodeFrame.refocus();
                    }
                } else {
                    MainPanel.this.loadFileToAssemblyCodeBox();
                }
            } else {
                MainPanel.this.saveFile();
            }
            MainPanel.this.assemblyCodeBox.requestFocusInWindow();
        }
    }

    private class Quit
    extends JButton {
        private Quit() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawLine(3, 5, this.getWidth() - 4, this.getHeight() - 6);
            g.drawLine(3, this.getHeight() - 6, this.getWidth() - 4, 5);
        }
    }

    private class WorkerThread
    extends Thread {
        private String assemblyCode;

        WorkerThread(String s) {
            this.assemblyCode = s;
        }

        @Override
        public void run() {
            MainPanel.this.runAssemblyCode(this.assemblyCode);
        }
    }
}

