/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.gui;

import edsim51sh.Assembler;
import edsim51sh.Cpu;
import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.gui.BitBox;
import edsim51sh.gui.InputBox;
import edsim51sh.settings.Settings;

public class ByteBox
extends InputBox {
    Cpu cpu;
    private Settings settings;
    private ByteBox bitfieldByteAddress;
    private BitBox[] bitfieldInputBoxes;

    public ByteBox(int address, String label, Cpu cpu, Settings settings, ByteBox bitfieldByteAddress, BitBox[] bitfieldInputBoxes) {
        super(address, label);
        this.cpu = cpu;
        this.settings = settings;
        this.bitfieldByteAddress = bitfieldByteAddress;
        this.bitfieldInputBoxes = bitfieldInputBoxes;
    }

    @Override
    void updateMemory() {
        try {
            this.cpu.memory.writeByte(this.address, this.getData());
            this.setData(this.cpu.memory.readByte(this.address));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateBitFieldData();
    }

    private void updateBitFieldData() {
        int byteFieldAddress = this.getBitFieldByteAddress();
        this.bitfieldByteAddress.setToolTipText("addr: " + Text.inHex(byteFieldAddress));
        String location = Assembler.getSfrName(byteFieldAddress);
        if (location.equals("")) {
            location = this.cpu.memory.getRegisterName(byteFieldAddress);
        }
        if (location == null) {
            location = Text.inHex(byteFieldAddress);
        }
        this.bitfieldByteAddress.setText(location);
        this.settings.setBitfieldByteAddressString(location);
        try {
            int data = byteFieldAddress == 128 || byteFieldAddress == 144 || byteFieldAddress == 160 || byteFieldAddress == 176 ? this.cpu.memory.readPortLatches(byteFieldAddress) : (byteFieldAddress == 153 ? this.cpu.memory.readSbufWriteOnly() : this.cpu.memory.readByte(byteFieldAddress));
            boolean isBitAddressable = Memory.isBitAddressable(byteFieldAddress);
            boolean editable = this.cpu.running && isBitAddressable;
            for (int i = 0; i < 8; ++i) {
                this.bitfieldInputBoxes[i].setData(data >> i & 1);
                this.bitfieldInputBoxes[i].setEditable(editable);
                String bitAddressName = isBitAddressable ? Assembler.getSbitName(byteFieldAddress + i) : this.getNonBitAddressableSbitName(location, i);
                if (bitAddressName.equals("")) {
                    this.bitfieldInputBoxes[i].setToolTipText(String.valueOf(i));
                    continue;
                }
                this.bitfieldInputBoxes[i].setToolTipText(bitAddressName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getBitFieldByteAddress() {
        String location = this.bitfieldByteAddress.getText().toUpperCase();
        int byteFieldAddress = Assembler.getSfrAddress(location);
        if (byteFieldAddress == -1 && location.length() == 2) {
            int registerNumber = location.charAt(1) - 48;
            if (location.charAt(0) == 'R' && registerNumber >= 0 && registerNumber <= 7) {
                try {
                    byteFieldAddress = this.cpu.memory.getRegisterAddress(registerNumber);
                }
                catch (Exception exception) {}
            } else {
                byteFieldAddress = -1;
            }
        }
        if (byteFieldAddress == -1 && (byteFieldAddress = Text.parseNumericData(location)) == 0x1000000) {
            byteFieldAddress = 224;
        }
        return byteFieldAddress;
    }

    private String getNonBitAddressableSbitName(String sfrName, int bitNumber) {
        if (sfrName.equals("PCON")) {
            return this.getPconBitName(bitNumber);
        }
        if (sfrName.equals("TMOD")) {
            return this.getTmodBitName(bitNumber);
        }
        return "";
    }

    private String getPconBitName(int bitNumber) {
        if (bitNumber == 7) {
            return "SMOD";
        }
        return "";
    }

    private String getTmodBitName(int bitNumber) {
        switch (bitNumber) {
            case 7: {
                return "T1: G";
            }
            case 6: {
                return "T1: C/T";
            }
            case 5: {
                return "T1: M1";
            }
            case 4: {
                return "T1: M0";
            }
            case 3: {
                return "T0: G";
            }
            case 2: {
                return "T0: C/T";
            }
            case 1: {
                return "T0: M1";
            }
            case 0: {
                return "T0: M0";
            }
        }
        return "";
    }
}

