/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.KeypadGraphics;
import edsim51di.Mapping;
import edsim51di.MotorGraphics;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class Motor
extends Peripheral {
    private double BIT0 = 3.0;
    private double BIT1 = 3.1;
    private double SENSOR = 3.5;
    private int bit0Port;
    private int bit0Pin;
    private int bit1Port;
    private int bit1Pin;
    private int sensorPort;
    private int sensorPin;
    private static final int ANGLE_STEP = 45;
    private int shaftPosition = 2;
    private double motorCurrent;
    private double count = this.motorCurrent = 7.0;
    private int sensorPosition = 0;
    private boolean motorEnabled;
    private MotorGraphics motorGraphics;
    private Board board;
    private KeypadGraphics keypad;

    Motor(Board board, KeypadGraphics keypad) {
        super("Motor", true);
        this.board = board;
        this.keypad = keypad;
        double[] d = board.getPortMapSetting("motor_bit0");
        if (d != null) {
            this.BIT0 = d[0];
        }
        if ((d = board.getPortMapSetting("motor_bit1")) != null) {
            this.BIT1 = d[0];
        }
        if ((d = board.getPortMapSetting("motor_sensor")) != null) {
            this.SENSOR = d[0];
        }
        this.bit0Port = this.getPortNumber(this.BIT0);
        this.bit0Pin = this.getPinNumber(this.BIT0);
        this.bit1Port = this.getPortNumber(this.BIT1);
        this.bit1Pin = this.getPinNumber(this.BIT1);
        this.sensorPort = this.getPortNumber(this.SENSOR);
        this.sensorPin = this.getPinNumber(this.SENSOR);
        String s = board.getHardwareSetting("motor");
        this.motorEnabled = s == null || s.equals("E");
        this.motorGraphics = new MotorGraphics(board, this);
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[3];
        interfaces[0] = new LogicDiagramInterface();
        interfaces[0].peripheralPin = 820;
        interfaces[0].portNumber = this.bit0Port;
        interfaces[0].pinNumber = this.bit0Pin;
        interfaces[1] = new LogicDiagramInterface();
        interfaces[1].peripheralPin = 840;
        interfaces[1].portNumber = this.bit1Port;
        interfaces[1].pinNumber = this.bit1Pin;
        interfaces[2] = new LogicDiagramInterface();
        interfaces[2].peripheralPin = 741;
        interfaces[2].portNumber = this.sensorPort;
        interfaces[2].pinNumber = this.sensorPin;
        return interfaces;
    }

    Mapping getBit0Mapping() {
        return new Mapping(this.bit0Port, this.bit0Pin, "Motor Control Bit 0");
    }

    Mapping getBit1Mapping() {
        return new Mapping(this.bit1Port, this.bit1Pin, "Motor Control Bit 1");
    }

    Mapping getSensorMapping() {
        return new Mapping(this.sensorPort, this.sensorPin, "Motor Sensor");
    }

    MotorGraphics getGraphics() {
        return this.motorGraphics;
    }

    boolean isEnabled() {
        return this.motorEnabled;
    }

    void enable() {
        this.motorEnabled = true;
    }

    void disable() {
        this.motorEnabled = false;
    }

    void setCurrent(int current) {
        this.motorCurrent = current;
        if (this.count > this.motorCurrent) {
            this.count = this.motorCurrent;
        }
    }

    void reset() {
        this.shaftPosition = 2;
    }

    void cycle(double microseconds) {
        if (this.motorEnabled) {
            boolean bit1;
            boolean bit0 = this.board.readPortPin(this.bit0Port, this.bit0Pin) == 1;
            boolean bl = bit1 = this.board.readPortPin(this.bit1Port, this.bit1Pin) == 1;
            if (bit0 != bit1) {
                this.count -= (double)this.board.getInstructionElapsedTimeInNanos() / 1000.0;
            }
            if (this.count <= 0.0) {
                this.count = this.motorCurrent;
                if (bit0) {
                    ++this.shaftPosition;
                    if (this.shaftPosition == 8) {
                        this.shaftPosition = 0;
                    }
                } else {
                    --this.shaftPosition;
                    if (this.shaftPosition == -1) {
                        this.shaftPosition = 7;
                    }
                }
            }
            if (this.shaftPosition == this.sensorPosition) {
                this.board.clearPortPin(this.sensorPort, this.sensorPin, 400);
                this.keypad.updateBitByExternalHardware(false, this.sensorPort, this.sensorPin);
            } else {
                this.board.setPortPin(this.sensorPort, this.sensorPin, 400);
                this.keypad.updateBitByExternalHardware(true, this.sensorPort, this.sensorPin);
            }
        }
    }

    void refreshGraphics() {
        this.motorGraphics.getMotorAnimation().setAngle(this.shaftPosition * 45);
        this.motorGraphics.getMotorAnimation().repaint();
    }
}

