/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;

class MotorAnimation
extends JPanel {
    private int radius;
    private int panelSizeSmall = 50;
    private int panelSizeLarge = 75;
    private int panelSize;
    private int sensorLenghSmall = 9;
    private int sensorLenghLarge = 13;
    private int sensorLength;
    private int centerX;
    private int centerY;
    private int angle = 90;

    MotorAnimation() {
    }

    void setSize(boolean small) {
        if (small) {
            this.panelSize = this.panelSizeSmall;
            this.sensorLength = this.sensorLenghSmall;
        } else {
            this.panelSize = this.panelSizeLarge;
            this.sensorLength = this.sensorLenghLarge;
        }
        this.radius = this.panelSize / 2 - 7;
        this.setMaximumSize(new Dimension(this.panelSize, this.panelSize));
        this.setMinimumSize(new Dimension(this.panelSize, this.panelSize));
        this.setPreferredSize(new Dimension(this.panelSize, this.panelSize));
    }

    void setAngle(int angle) {
        this.angle = angle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.centerX = this.panelSize / 2;
        this.centerY = this.panelSize / 2 + 5;
        g.setColor(Color.BLACK);
        g.drawOval(this.centerX - this.radius, this.centerY - this.radius, this.radius * 2, this.radius * 2);
        Point p = this.getShaftPosition(this.radius, this.angle);
        g.drawLine(this.centerX, this.centerY, p.x, p.y);
        if (this.angle == 0) {
            g.setColor(Color.RED);
        }
        g.drawLine(this.centerX, 0, this.centerX, this.sensorLength);
    }

    private Point getShaftPosition(int shaftLength, double degrees) {
        double y = (double)shaftLength * Math.cos(Math.toRadians(degrees));
        double x = (double)shaftLength * Math.sin(Math.toRadians(degrees));
        return new Point(this.centerX + (int)x, this.centerY - (int)y);
    }
}

